/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore;

import eu.dnetlib.data.objectstore.ModularObjectStoreDeliver;
import eu.dnetlib.miscutils.datetime.HumanTime;
import eu.dnetlib.rmi.data.ObjectStoreFile;
import eu.dnetlib.rmi.data.ObjectStoreServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ModularObjectStoreRESTService {
    private static final Log log = LogFactory.getLog(ModularObjectStoreRESTService.class);
    @Autowired
    ModularObjectStoreDeliver objectStoreDeliver;

    @RequestMapping(value={"/**/objectStore/retrieve.do"})
    public void retrieve(HttpServletResponse res, @RequestParam(value="objectStore", required=true) String objectStoreId, @RequestParam(value="objectId", required=true) String objectId) throws IOException, ObjectStoreServiceException {
        long start = System.currentTimeMillis();
        ObjectStoreFile file = this.objectStoreDeliver.deliverObject(objectStoreId, objectId);
        log.debug((Object)String.format("deliverObject completed in %s, objId: %s", HumanTime.exactly((long)(System.currentTimeMillis() - start)), objectId));
        if (file == null) {
            throw new RuntimeException("The file with id " + objectId + " doesn't exist");
        }
        InputStream is = this.objectStoreDeliver.deliverStream(objectStoreId, objectId);
        ServletOutputStream outputStream = res.getOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)outputStream);
        try {
            is.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("retrive.do completed in %s, objId: %s", HumanTime.exactly((long)(System.currentTimeMillis() - start)), objectId));
            }
        }
        catch (Throwable e) {
            log.error((Object)"unable to close input Stream", e);
        }
    }
}

