/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore;

import eu.dnetlib.data.objectstore.ObjectStoreRecord;
import eu.dnetlib.rmi.data.Protocols;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;

public class ObjectBroker
implements Function<ObjectStoreRecord, ObjectStoreRecord> {
    private static final Log log = LogFactory.getLog(ObjectBroker.class);
    private Protocols protocol;
    private String login;
    private String password;
    private String mime;

    public ObjectBroker(Protocols protocol, String login, String password, String mime) {
        this.protocol = protocol;
        this.login = login;
        this.password = password;
        this.mime = mime;
    }

    public Protocols getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocols protocol) {
        this.protocol = protocol;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMime() {
        return this.mime;
    }

    public void setMime(String mime) {
        this.mime = mime;
    }

    @Override
    public ObjectStoreRecord apply(ObjectStoreRecord objectStorerecord) {
        if (objectStorerecord == null) {
            return null;
        }
        Protocols currentProtocol = objectStorerecord.getFileMetadata().getAccessProtocol() == Protocols.None ? this.protocol : objectStorerecord.getFileMetadata().getAccessProtocol();
        objectStorerecord.getFileMetadata().setAccessProtocol(currentProtocol);
        if (objectStorerecord.getFileMetadata().getMimeType() == null || objectStorerecord.getFileMetadata().getMimeType().length() == 0) {
            objectStorerecord.getFileMetadata().setMimeType(this.mime);
        }
        switch (currentProtocol) {
            case FTP: {
                FTPClient client = new FTPClient();
                try {
                    URI uri = new URI(objectStorerecord.getFileMetadata().getURI());
                    client.connect(uri.getHost());
                    if (objectStorerecord.getFileMetadata().getUsernameAuth() != null && objectStorerecord.getFileMetadata().getUsernameAuth().length() > 0) {
                        client.login(objectStorerecord.getFileMetadata().getUsernameAuth(), objectStorerecord.getFileMetadata().getPasswordAuth());
                    } else {
                        client.login("ftp", "a@a");
                    }
                    InputStream stream = client.retrieveFileStream(uri.getPath());
                    objectStorerecord.setInputStream(stream);
                    return objectStorerecord;
                }
                catch (URISyntaxException e2) {
                    log.error((Object)e2);
                    return null;
                }
                catch (SocketException e) {
                    log.error((Object)e);
                }
                catch (IOException e) {
                    log.error((Object)e);
                    return null;
                }
            }
            case HTTP: {
                try {
                    HttpURLConnection conn = (HttpURLConnection)new URL(objectStorerecord.getFileMetadata().getURI()).openConnection();
                    try {
                        int http_status = conn.getResponseCode();
                        if (http_status / 100 == 3) {
                            String newURL = conn.getHeaderField("Location");
                            conn.disconnect();
                            conn = (HttpURLConnection)new URL(newURL).openConnection();
                            http_status = conn.getResponseCode();
                            if (http_status / 100 != 2) {
                                return null;
                            }
                        }
                        InputStream in = conn.getInputStream();
                        objectStorerecord.setInputStream(in);
                        return objectStorerecord;
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                        return null;
                    }
                }
                catch (MalformedURLException e1) {
                    log.error((Object)e1);
                    return null;
                }
                catch (IOException e1) {
                    log.error((Object)e1);
                    return null;
                }
            }
            case File_System: {
                File f = new File(objectStorerecord.getFileMetadata().getURI());
                try {
                    FileInputStream myiInputStream = new FileInputStream(f);
                    objectStorerecord.setInputStream(myiInputStream);
                    return objectStorerecord;
                }
                catch (FileNotFoundException e) {
                    try {
                        Thread.sleep(5000L);
                        FileInputStream myiInputStream = new FileInputStream(f);
                        objectStorerecord.setInputStream(myiInputStream);
                        return objectStorerecord;
                    }
                    catch (Exception e1) {
                        log.error((Object)e1);
                        return null;
                    }
                }
            }
        }
        return null;
    }
}

