/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transformation.inspector;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import eu.dnetlib.data.transformation.service.DataTransformerFactory;
import eu.dnetlib.data.transformation.service.SimpleDataTransformer;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DataTransformationController
extends AbstractInspectorController {
    @Autowired
    private DataTransformerFactory dataTransformerFactory;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    @RequestMapping(value={"/inspector/transform.do"})
    public void transform(Model model, @RequestParam(value="rule", required=false) String ruleId, @RequestParam(value="record", required=false) String record) throws Exception {
        model.addAttribute("rules", this.obtainRuleProfiles(ruleId));
        if (ruleId != null && record != null) {
            SimpleDataTransformer transformer = this.dataTransformerFactory.createTransformer(ruleId);
            model.addAttribute("input", (Object)record);
            model.addAttribute("output", (Object)transformer.apply(record));
        }
    }

    private List<SelectOption> obtainRuleProfiles(final String currentId) throws ISLookUpException {
        String xquery = "for $x in collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType') return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x//TITLE)";
        return Lists.transform((List)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xquery), (Function)new Function<String, SelectOption>(){

            public SelectOption apply(String value) {
                String[] arr = value.split("@@@");
                String id = arr[0].trim();
                String name = arr[1].trim();
                return new SelectOption(id, name, id.equals(currentId));
            }
        });
    }

    public static class SelectOption {
        private String id;
        private String name;
        private boolean selected;

        public SelectOption(String id, String name, boolean selected) {
            this.id = id;
            this.name = name;
            this.selected = selected;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSelected() {
            return this.selected;
        }
    }
}

