/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.miscutils.collections.Pair;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDNetXsltFunctions {
    public static final String URL_REGEX = "^(http|https|ftp)\\://.*";
    private static final int MAX_NSPREFIX_LEN = 12;
    public static Predicate<String> urlFilter = s -> s.trim().matches(URL_REGEX);

    protected static DNGFProtos.DNGF getOaf(DNGFProtos.DNGFEntity.Builder entity, FieldTypeProtos.DataInfo.Builder info) {
        return AbstractDNetXsltFunctions._getOaf(DNGFProtos.DNGF.newBuilder(), info).setKind(KindProtos.Kind.entity).setEntity(entity).build();
    }

    protected static DNGFProtos.DNGF getOaf(DNGFProtos.DNGFRel.Builder rel, FieldTypeProtos.DataInfo.Builder info) {
        return AbstractDNetXsltFunctions._getOaf(DNGFProtos.DNGF.newBuilder(), info).setKind(KindProtos.Kind.relation).setRel(rel).build();
    }

    private static DNGFProtos.DNGF.Builder _getOaf(DNGFProtos.DNGF.Builder oaf, FieldTypeProtos.DataInfo.Builder info) {
        if (info != null) {
            return oaf.setDataInfo(AbstractDNetXsltFunctions.ensureDataInfo(info));
        }
        return oaf;
    }

    protected static FieldTypeProtos.DataInfo.Builder ensureDataInfo(FieldTypeProtos.DataInfo.Builder info) {
        if (info.isInitialized()) {
            return info;
        }
        return AbstractDNetXsltFunctions.getDataInfo(null, "UNKNOWN", "0.9", false, false);
    }

    protected static FieldTypeProtos.KeyValue getKV(String id, String name) {
        return FieldTypeProtos.KeyValue.newBuilder().setKey(id).setValue(name).build();
    }

    protected static DNGFProtos.DNGFRel.Builder getRel(String sourceId, TypeProtos.Type sourceType, String targetId, TypeProtos.Type targetType, FieldTypeProtos.Qualifier relType, boolean isChild) {
        return DNGFProtos.DNGFRel.newBuilder().setSource(sourceId).setTarget(targetId).setSourceType(sourceType).setTargetType(targetType).setRelType(relType).setChild(isChild);
    }

    protected static DNGFProtos.DNGFEntity.Builder getEntity(TypeProtos.Type type, String id, FieldTypeProtos.KeyValue collectedFrom, List<String> originalIds, String dateOfCollection, String dateOfTransformation, List<FieldTypeProtos.StructuredProperty> pids) {
        DNGFProtos.DNGFEntity.Builder builder = DNGFProtos.DNGFEntity.newBuilder().setType(type).setId(id);
        if (collectedFrom != null) {
            builder.addCollectedfrom(collectedFrom);
        }
        builder.setDateoftransformation(StringUtils.isBlank((CharSequence)dateOfTransformation) ? "" : dateOfTransformation);
        builder.setDateofcollection(StringUtils.isBlank((CharSequence)dateOfCollection) ? "" : dateOfCollection);
        if (originalIds != null && !originalIds.isEmpty()) {
            builder.addAllOriginalId(Iterables.filter(originalIds, AbstractDNetXsltFunctions.getPredicateNotBlankString()));
        }
        if (pids != null && !pids.isEmpty()) {
            builder.addAllPid(Iterables.filter(pids, (Predicate)Predicates.notNull()));
        }
        return builder;
    }

    public static Predicate<String> getPredicateNotBlankString() {
        return s -> StringUtils.isNotBlank((CharSequence)s);
    }

    public static FieldTypeProtos.DataInfo.Builder getDataInfo(NodeList about, String provenanceaction, String trust, boolean deletedbyinference, boolean inferred) {
        Element dataInfoElement;
        FieldTypeProtos.DataInfo.Builder dataInfoBuilder = FieldTypeProtos.DataInfo.newBuilder();
        dataInfoBuilder.setInferred(inferred);
        dataInfoBuilder.setDeletedbyinference(deletedbyinference);
        dataInfoBuilder.setTrust(trust);
        dataInfoBuilder.setProvenanceaction(AbstractDNetXsltFunctions.getSimpleQualifier(provenanceaction, "dnet:provenanceActions").build());
        if (about != null && about.getLength() > 0 && (dataInfoElement = AbstractDNetXsltFunctions.getDirectChild((Element)about.item(0), "datainfo")) != null) {
            Element elem = AbstractDNetXsltFunctions.getDirectChild(dataInfoElement, "inferred");
            dataInfoBuilder.setInferred(Boolean.valueOf(AbstractDNetXsltFunctions.getStringValue(elem, String.valueOf(inferred))));
            elem = AbstractDNetXsltFunctions.getDirectChild(dataInfoElement, "deletedbyinference");
            dataInfoBuilder.setDeletedbyinference(Boolean.valueOf(AbstractDNetXsltFunctions.getStringValue(elem, String.valueOf(deletedbyinference))));
            elem = AbstractDNetXsltFunctions.getDirectChild(dataInfoElement, "trust");
            dataInfoBuilder.setTrust(AbstractDNetXsltFunctions.getStringValue(elem, trust));
            elem = AbstractDNetXsltFunctions.getDirectChild(dataInfoElement, "inferenceprovenance");
            dataInfoBuilder.setInferenceprovenance(AbstractDNetXsltFunctions.getStringValue(elem));
            elem = AbstractDNetXsltFunctions.getDirectChild(dataInfoElement, "provenanceaction");
            FieldTypeProtos.Qualifier.Builder pBuilder = FieldTypeProtos.Qualifier.newBuilder();
            if (elem != null && elem.hasAttributes()) {
                NamedNodeMap attributes = elem.getAttributes();
                pBuilder.setClassid(AbstractDNetXsltFunctions.getAttributeValue(attributes, "classid"));
                pBuilder.setClassname(AbstractDNetXsltFunctions.getAttributeValue(attributes, "classname"));
                pBuilder.setSchemeid(AbstractDNetXsltFunctions.getAttributeValue(attributes, "schemeid"));
                pBuilder.setSchemename(AbstractDNetXsltFunctions.getAttributeValue(attributes, "schemename"));
            } else {
                pBuilder.mergeFrom(AbstractDNetXsltFunctions.getSimpleQualifier(provenanceaction, "dnet:provenanceActions").build());
            }
            dataInfoBuilder.setProvenanceaction(pBuilder);
        }
        return dataInfoBuilder;
    }

    protected static FieldTypeProtos.OAIProvenance getOAIProvenance(NodeList about) {
        Element provenance;
        FieldTypeProtos.OAIProvenance.Builder oaiProv = FieldTypeProtos.OAIProvenance.newBuilder();
        if (about != null && about.getLength() > 0 && (provenance = AbstractDNetXsltFunctions.getDirectChild((Element)about.item(0), "provenance")) != null) {
            Element origDesc = AbstractDNetXsltFunctions.getDirectChild(provenance, "originDescription");
            oaiProv.setOriginDescription(AbstractDNetXsltFunctions.buildOriginDescription(origDesc, FieldTypeProtos.OAIProvenance.OriginDescription.newBuilder()));
        }
        return oaiProv.build();
    }

    private static FieldTypeProtos.OAIProvenance.OriginDescription buildOriginDescription(Element origDesc, FieldTypeProtos.OAIProvenance.OriginDescription.Builder od) {
        od.setHarvestDate(origDesc.getAttribute("harvestDate")).setAltered(Boolean.valueOf(origDesc.getAttribute("altered")));
        Element elem = AbstractDNetXsltFunctions.getDirectChild(origDesc, "baseURL");
        od.setBaseURL(AbstractDNetXsltFunctions.getStringValue(elem));
        elem = AbstractDNetXsltFunctions.getDirectChild(origDesc, "identifier");
        od.setIdentifier(AbstractDNetXsltFunctions.getStringValue(elem));
        elem = AbstractDNetXsltFunctions.getDirectChild(origDesc, "datestamp");
        od.setDatestamp(AbstractDNetXsltFunctions.getStringValue(elem));
        elem = AbstractDNetXsltFunctions.getDirectChild(origDesc, "metadataNamespace");
        od.setMetadataNamespace(AbstractDNetXsltFunctions.getStringValue(elem));
        elem = AbstractDNetXsltFunctions.getDirectChild(origDesc, "originDescription");
        if (elem != null) {
            od.setOriginDescription(AbstractDNetXsltFunctions.buildOriginDescription(elem, FieldTypeProtos.OAIProvenance.OriginDescription.newBuilder()));
        }
        return od.build();
    }

    protected static String getStringValue(Element elem, String defaultValue) {
        return elem != null && elem.getTextContent() != null ? elem.getTextContent() : defaultValue;
    }

    protected static String getStringValue(Element elem) {
        return AbstractDNetXsltFunctions.getStringValue(elem, "");
    }

    protected static String getAttributeValue(NamedNodeMap attributes, String name) {
        Node attr = attributes.getNamedItem(name);
        if (attr == null) {
            return "";
        }
        String value = attr.getNodeValue();
        return value != null ? value : "";
    }

    protected static Element getDirectChild(Element parent, String name) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !name.equals(child.getLocalName())) continue;
            return (Element)child;
        }
        return null;
    }

    protected static FieldTypeProtos.Qualifier.Builder getSimpleQualifier(String classname, String schemename) {
        return AbstractDNetXsltFunctions.getQualifier(classname, classname, schemename, schemename);
    }

    protected static FieldTypeProtos.Qualifier.Builder getSimpleQualifier(ProtocolMessageEnum classname, String schemename) {
        return AbstractDNetXsltFunctions.getQualifier(classname.toString(), classname.toString(), schemename, schemename);
    }

    protected static FieldTypeProtos.Qualifier.Builder getQualifier(String classid, String classname, String schemeid, String schemename) {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid(classid).setClassname(classname).setSchemeid(schemeid).setSchemename(schemename);
    }

    protected static FieldTypeProtos.Qualifier.Builder setQualifier(FieldTypeProtos.Qualifier.Builder qualifier, List<String> fields) {
        if (fields == null || fields.isEmpty() || fields.get(0).isEmpty()) {
            return null;
        }
        if (fields != null && !fields.isEmpty() && fields.get(0) != null) {
            qualifier.setClassid(fields.get(0));
            qualifier.setClassname(fields.get(0));
        }
        return qualifier;
    }

    protected static void addStructuredProps(Message.Builder builder, Descriptors.FieldDescriptor fd, List<String> values, String classid, String schemeid) {
        if (values != null) {
            for (String s : values) {
                AbstractDNetXsltFunctions.addField(builder, fd, AbstractDNetXsltFunctions.getStructuredProperty(s, classid, classid, schemeid, schemeid));
            }
        }
    }

    protected static List<FieldTypeProtos.StructuredProperty> parsePids(NodeList nodelist) {
        ArrayList pids = Lists.newArrayList();
        block0: for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            Node pidType = null;
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equalsIgnoreCase("identifier")) {
                pidType = node.getAttributes().getNamedItem("identifierType");
            }
            if (node.getLocalName().equalsIgnoreCase("alternateIdentifier")) {
                pidType = node.getAttributes().getNamedItem("alternateIdentifierType");
            }
            for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                Node child = node.getChildNodes().item(j);
                if (child.getNodeType() != 3 || pidType == null || pidType.getNodeValue() == null || pidType.getNodeValue().isEmpty() || pidType.getNodeValue().equalsIgnoreCase("url")) continue;
                String type = pidType.getNodeValue().toLowerCase();
                String value = child.getTextContent();
                pids.add(AbstractDNetXsltFunctions.getStructuredProperty(value, type, type, "dnet:pid_types", "dnet:pid_types"));
                continue block0;
            }
        }
        return pids;
    }

    protected static void addField(Message.Builder builder, Descriptors.FieldDescriptor descriptor, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof List) {
            for (Object o : (List)value) {
                AbstractDNetXsltFunctions.addField(builder, descriptor, o);
            }
        } else {
            Object fieldValue = value;
            switch (descriptor.getType()) {
                case BOOL: {
                    fieldValue = Boolean.valueOf(value.toString());
                    break;
                }
                case BYTES: {
                    fieldValue = value.toString().getBytes(Charset.forName("UTF-8"));
                    break;
                }
                case DOUBLE: {
                    fieldValue = Double.valueOf(value.toString());
                    break;
                }
                case FLOAT: {
                    fieldValue = Float.valueOf(value.toString());
                    break;
                }
                case INT32: 
                case INT64: 
                case SINT32: 
                case SINT64: {
                    fieldValue = Integer.valueOf(value.toString());
                    break;
                }
                case MESSAGE: {
                    Message.Builder q = builder.newBuilderForField(descriptor);
                    if (value instanceof Message.Builder) {
                        value = ((Message.Builder)value).build();
                        byte[] b = ((Message)value).toByteArray();
                        try {
                            q.mergeFrom(b);
                        }
                        catch (InvalidProtocolBufferException e) {
                            throw new IllegalArgumentException("Unable to merge value: " + value + " with builder: " + q.getDescriptorForType().getName());
                        }
                    } else if (FieldTypeProtos.Qualifier.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.Qualifier) {
                            q.mergeFrom((Message)((FieldTypeProtos.Qualifier)value));
                        } else {
                            AbstractDNetXsltFunctions.parseMessage(q, FieldTypeProtos.Qualifier.getDescriptor(), value.toString(), "@@@");
                        }
                    } else if (FieldTypeProtos.StructuredProperty.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.StructuredProperty) {
                            q.mergeFrom((Message)((FieldTypeProtos.StructuredProperty)value));
                        } else {
                            AbstractDNetXsltFunctions.parseMessage(q, FieldTypeProtos.StructuredProperty.getDescriptor(), value.toString(), "###");
                        }
                    } else if (FieldTypeProtos.KeyValue.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.KeyValue) {
                            q.mergeFrom((Message)((FieldTypeProtos.KeyValue)value));
                        } else {
                            AbstractDNetXsltFunctions.parseMessage(q, FieldTypeProtos.KeyValue.getDescriptor(), value.toString(), "&&&");
                        }
                    } else if (FieldTypeProtos.StringField.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.StringField) {
                            q.mergeFrom((Message)((FieldTypeProtos.StringField)value));
                        } else {
                            q.setField(FieldTypeProtos.StringField.getDescriptor().findFieldByName("value"), value);
                        }
                    } else if (FieldTypeProtos.BoolField.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.BoolField) {
                            q.mergeFrom((Message)((FieldTypeProtos.BoolField)value));
                        } else if (value instanceof String) {
                            q.setField(FieldTypeProtos.BoolField.getDescriptor().findFieldByName("value"), (Object)Boolean.valueOf((String)value));
                        } else {
                            q.setField(FieldTypeProtos.BoolField.getDescriptor().findFieldByName("value"), value);
                        }
                    } else if (FieldTypeProtos.IntField.getDescriptor().getName().equals(q.getDescriptorForType().getName())) {
                        if (value instanceof FieldTypeProtos.IntField) {
                            q.mergeFrom((Message)((FieldTypeProtos.IntField)value));
                        } else if (value instanceof String) {
                            q.setField(FieldTypeProtos.IntField.getDescriptor().findFieldByName("value"), (Object)NumberUtils.toInt((String)((String)value)));
                        } else {
                            q.setField(FieldTypeProtos.IntField.getDescriptor().findFieldByName("value"), value);
                        }
                    }
                    fieldValue = q.buildPartial();
                    break;
                }
            }
            AbstractDNetXsltFunctions.doAddField(builder, descriptor, fieldValue);
        }
    }

    protected static void doAddField(Message.Builder builder, Descriptors.FieldDescriptor fd, Object value) {
        if (value != null) {
            if (fd.isRepeated()) {
                builder.addRepeatedField(fd, value);
            } else if (fd.isOptional() || fd.isRequired()) {
                builder.setField(fd, value);
            }
        }
    }

    protected static void parseMessage(Message.Builder builder, Descriptors.Descriptor descriptor, String value, String split) {
        Iterable iterablePair = () -> {
            final Iterator fields = descriptor.getFields().iterator();
            final Iterator values = Lists.newArrayList((Iterable)Splitter.on((String)split).trimResults().split((CharSequence)value)).iterator();
            return new Iterator<Pair>(){

                @Override
                public boolean hasNext() {
                    return fields.hasNext() && values.hasNext();
                }

                @Override
                public Pair next() {
                    Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)fields.next();
                    String value1 = (String)values.next();
                    return new Pair((Object)field, (Object)value1);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("cannot remove");
                }
            };
        };
        for (Pair p : iterablePair) {
            AbstractDNetXsltFunctions.addField(builder, (Descriptors.FieldDescriptor)p.getKey(), p.getValue());
        }
    }

    protected static String base64(byte[] data) {
        byte[] bytes = Base64.encodeBase64((byte[])data);
        return new String(bytes);
    }

    public static String replace(String s, String regex, String replacement) {
        return s.replaceAll(regex, replacement);
    }

    public static String trim(String s) {
        return s.trim();
    }

    protected static String removePrefix(TypeProtos.Type type, String s) {
        return AbstractDNetXsltFunctions.removePrefix(type.toString(), s);
    }

    private static String removePrefix(String prefix, String s) {
        return StringUtils.removeStart((String)("" + s), (String)(prefix + "|"));
    }

    protected static FieldTypeProtos.Qualifier.Builder getDefaultQualifier(String scheme) {
        FieldTypeProtos.Qualifier.Builder qualifier = FieldTypeProtos.Qualifier.newBuilder().setSchemeid(scheme).setSchemename(scheme);
        return qualifier;
    }

    protected static FieldTypeProtos.StructuredProperty getStructuredProperty(String value, String classid, String classname, String schemeid, String schemename) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return FieldTypeProtos.StructuredProperty.newBuilder().setValue(value).setQualifier(AbstractDNetXsltFunctions.getQualifier(classid, classname, schemeid, schemename)).build();
    }

    protected static FieldTypeProtos.StringField.Builder sf(String s) {
        return FieldTypeProtos.StringField.newBuilder().setValue(s);
    }

    public static String generateNsPrefix(String prefix, String externalId) {
        return StringUtils.substring((String)(prefix + StringUtils.leftPad((String)externalId, (int)(12 - prefix.length()), (String)"_")), (int)0, (int)12);
    }

    public static String md5(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes("UTF-8"));
            return new String(Hex.encodeHex((byte[])md.digest()));
        }
        catch (Exception e) {
            System.err.println("Error creating id");
            return null;
        }
    }

    public static String oafId(String entityType, String prefix, String id) {
        if (id.isEmpty() || prefix.isEmpty()) {
            return "";
        }
        return AbstractDNetXsltFunctions.oafSimpleId(entityType, prefix + "::" + AbstractDNetXsltFunctions.md5(id));
    }

    public static String oafSimpleId(String entityType, String id) {
        String returnValue = (TypeProtos.Type.valueOf(entityType).getNumber() + "|" + id).replaceAll("\\s|\\n", "");
        return returnValue;
    }

    public static String oafSplitId(String entityType, String fullId) {
        return AbstractDNetXsltFunctions.oafId(entityType, StringUtils.substringBefore((String)fullId, (String)"::"), StringUtils.substringAfter((String)fullId, (String)"::"));
    }

    public static Object lookupValue(Map<String, Object> map, String key) {
        return map.get(key);
    }

    public static int mustMerge(Map<String, Object> map, String key) {
        Object val = AbstractDNetXsltFunctions.lookupValue(map, key);
        return val != null && val instanceof String && val.equals("true") ? 1 : 0;
    }
}

