package eu.dnetlib.data.graph.model;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

import com.google.protobuf.Descriptors.FieldDescriptor;
import com.google.protobuf.GeneratedMessage;
import eu.dnetlib.data.proto.DNGFProtos.DNGFEntity;
import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.data.transform.AbstractProtoMapper;

public class DNGFEntityDecoder extends AbstractProtoMapper {

	private final DNGFEntity dngfEntity;

	private DNGFEntityDecoder(final DNGFEntity oafEntity) {
		this.dngfEntity = oafEntity;
	}

	public static DNGFEntityDecoder decode(final DNGFEntity oafEntity) {
		return new DNGFEntityDecoder(oafEntity);
	}

	public Type getType() {
		return dngfEntity.getType();
	}

	public String getId() {
		return dngfEntity.getId();
	}

	public GeneratedMessage getDNGFEntity() {
		return dngfEntity;
	}

	public GeneratedMessage getEntity() {
		final FieldDescriptor fd = dngfEntity.getDescriptorForType().findFieldByName(typeName());
		return (GeneratedMessage) dngfEntity.getField(fd);
	}

	public String typeName() {
		return dngfEntity.getType().toString();
	}

	public GeneratedMessage getMetadata() {
		final GeneratedMessage entity = getEntity();
		final FieldDescriptor fd = entity.getDescriptorForType().findFieldByName("metadata");
		final GeneratedMessage field = (GeneratedMessage) entity.getField(fd);
		return field;
	}

	public List<String> getFieldValues(final String path) {
		return processPath(getDNGFEntity(), path, eu.dnetlib.pace.config.Type.String)
				.stream()
				.map(o -> o.toString())
				.collect(Collectors.toCollection(() -> new LinkedList<>()));
	}

	public String getDateOfCollection() {
		return dngfEntity.getDateofcollection();
	}

	public String getDateOfTransformation() {
		return dngfEntity.getDateoftransformation();
	}
}
