package eu.dnetlib.data.transform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;

import eu.dnetlib.data.proto.DNGFProtos.DNGF;
import eu.dnetlib.data.proto.SpecialTrustProtos.SpecialTrust;

public class TrustOrdering extends Ordering<DNGF> {

	@Override
	public int compare(DNGF left, DNGF right) {
		String lTrust = left.getDataInfo().getTrust();
		String rTrust = right.getDataInfo().getTrust();

		if (lTrust.equals(rTrust)) return 0;

		if (lTrust.equals(SpecialTrust.INFINITE.toString())) return 1;
		if (rTrust.equals(SpecialTrust.INFINITE.toString())) return -1;

		if (lTrust.equals(SpecialTrust.NEUTRAL.toString())) return 1;
		if (rTrust.equals(SpecialTrust.NEUTRAL.toString())) return -1;

		return Float.compare(Float.parseFloat(lTrust), Float.parseFloat(rTrust));
	}

	public static ImmutableList<DNGF> sort(Iterable<DNGF> entities) {
		return new TrustOrdering().immutableSortedCopy(entities);
	}

}
