/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.graph.model.DNGFUtils;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DatasetProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.KindProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.PublicationProtos;
import eu.dnetlib.data.proto.SpecialTrustProtos;
import eu.dnetlib.pace.config.DedupConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DNGFEntityMerger {
    private static final String DEDUP_CLASSID = "sysimport:dedup";
    private static final String DNET_PROVENANCE_SCHEME = "dnet:provenanceActions";
    private final Predicate<FieldTypeProtos.StringField> skipEmptyStringField = s -> s != null && s.getValue() != null && !s.getValue().isEmpty();
    private final Predicate<String> skipEmptyString = s -> StringUtils.isNotBlank((CharSequence)s);

    public static DNGFProtos.DNGF.Builder merge(String id, Iterable<DNGFProtos.DNGF> entities) {
        return DNGFEntityMerger.merge(null, id, entities);
    }

    public static DNGFProtos.DNGF.Builder merge(DedupConfig dedupConf, String id, Iterable<DNGFProtos.DNGF> entities) {
        return new DNGFEntityMerger().mergeEntities(dedupConf, id, entities);
    }

    public static DNGFProtos.DNGF.Builder merge(DNGFProtos.DNGF.Builder builder) {
        return new DNGFEntityMerger().doMergeEntities(builder);
    }

    public DNGFProtos.DNGF.Builder mergeEntities(DedupConfig dedupConf, String id, Iterable<DNGFProtos.DNGF> entities) {
        DNGFProtos.DNGF.Builder builder = DNGFProtos.DNGF.newBuilder();
        String trust = "0.0";
        for (DNGFProtos.DNGF dngf : entities) {
            if (!dngf.getKind().equals((Object)KindProtos.Kind.entity)) {
                throw new IllegalArgumentException("expected DNGFEntity!");
            }
            String currentTrust = dngf.getDataInfo().getTrust();
            if (!currentTrust.equals(SpecialTrustProtos.SpecialTrust.NEUTRAL.toString())) {
                trust = currentTrust;
            }
            builder.mergeFrom(dngf);
            if (!StringUtils.isBlank((CharSequence)currentTrust)) continue;
            builder.getDataInfoBuilder().setTrust("0.8");
        }
        builder = this.doMergeEntities(builder);
        builder.getEntityBuilder().setId(id);
        builder.getDataInfoBuilder().setInferred(true).setDeletedbyinference(false).setTrust(trust).setInferenceprovenance(dedupConf != null ? dedupConf.getWf().getConfigurationId() : "").setProvenanceaction(this.getProvenanceAction());
        if (dedupConf != null && dedupConf.getWf().isIncludeChildren()) {
            for (DNGFProtos.DNGF dngf : Iterables.limit(entities, (int)dedupConf.getWf().getMaxChildren())) {
                builder.getEntityBuilder().addChildren(dngf.getEntity());
            }
        }
        return builder;
    }

    private FieldTypeProtos.Qualifier.Builder getProvenanceAction() {
        return FieldTypeProtos.Qualifier.newBuilder().setClassid(DEDUP_CLASSID).setClassname(DEDUP_CLASSID).setSchemeid(DNET_PROVENANCE_SCHEME).setSchemename(DNET_PROVENANCE_SCHEME);
    }

    public DNGFProtos.DNGF.Builder doMergeEntities(DNGFProtos.DNGF.Builder builder) {
        for (String string : DNGFUtils.getFieldNames(DNGFProtos.DNGFEntity.getDescriptor(), 9)) {
            this.setKeyValues((Message.Builder)builder.getEntityBuilder(), string);
        }
        for (String string : DNGFUtils.getFieldNames(DNGFProtos.DNGFEntity.getDescriptor(), 10)) {
            this.setStructuredProperty((Message.Builder)builder.getEntityBuilder(), string);
        }
        for (String string : DNGFUtils.getFieldNames(DNGFProtos.DNGFEntity.getDescriptor(), 8)) {
            this.setUniqueString((Message.Builder)builder.getEntityBuilder(), string);
        }
        switch (builder.getEntity().getType()) {
            case datasource: {
                break;
            }
            case organization: {
                break;
            }
            case person: {
                PersonProtos.Person.Builder person = builder.getEntityBuilder().getPersonBuilder().setAnchor(true);
                for (String string : DNGFUtils.getFieldNames(PersonProtos.Person.Metadata.getDescriptor(), 2)) {
                    this.setSingleString((Message.Builder)person.getMetadataBuilder(), string);
                }
                HashMap hashMap = Maps.newHashMap();
                for (PersonProtos.Person.MergedPerson mergedPerson : person.getMergedpersonList()) {
                    hashMap.put(mergedPerson.getId(), mergedPerson);
                }
                person.clearMergedperson().addAllMergedperson(hashMap.values());
                HashMap hashMap2 = Maps.newHashMap();
                for (PersonProtos.Person.CoAuthor coAuthor : person.getCoauthorList()) {
                    hashMap2.put(coAuthor.getId(), coAuthor);
                }
                person.clearCoauthor().addAllCoauthor(hashMap2.values());
                break;
            }
            case project: {
                break;
            }
            case publication: {
                PublicationProtos.Publication.Metadata.Builder builder2 = builder.getEntityBuilder().getPublicationBuilder().getMetadataBuilder();
                this.setTitle(builder2);
                for (String field : DNGFUtils.getFieldNames(PublicationProtos.Publication.Metadata.getDescriptor(), 1, 3)) {
                    this.setStructuredProperty((Message.Builder)builder2, field);
                }
                for (String field : DNGFUtils.getFieldNames(PublicationProtos.Publication.Metadata.getDescriptor(), 25)) {
                    this.setLongestStringField((Message.Builder)builder2, field);
                }
                for (String field : DNGFUtils.getFieldNames(PublicationProtos.Publication.Metadata.getDescriptor(), 27)) {
                    this.setUniqueStringField((Message.Builder)builder2, field);
                }
                builder.getEntityBuilder().getPublicationBuilder().clearAuthor();
                break;
            }
            case dataset: {
                DatasetProtos.Dataset.Metadata.Builder dataset = builder.getEntityBuilder().getDatasetBuilder().getMetadataBuilder();
                this.setTitle(dataset);
                for (String field : DNGFUtils.getFieldNames(PublicationProtos.Publication.Metadata.getDescriptor(), 1, 3)) {
                    this.setStructuredProperty((Message.Builder)dataset, field);
                }
                for (String field : DNGFUtils.getFieldNames(PublicationProtos.Publication.Metadata.getDescriptor(), 25)) {
                    this.setLongestStringField((Message.Builder)dataset, field);
                }
                for (String field : DNGFUtils.getFieldNames(PublicationProtos.Publication.Metadata.getDescriptor(), 27)) {
                    this.setUniqueStringField((Message.Builder)dataset, field);
                }
                builder.getEntityBuilder().getDatasetBuilder().clearAuthor();
                break;
            }
        }
        return builder;
    }

    private void setStructuredProperty(Message.Builder builder, String fieldName) {
        HashMap map = Maps.newHashMap();
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List sps = (List)builder.getField(fd);
        if (sps != null && !sps.isEmpty()) {
            for (FieldTypeProtos.StructuredProperty sp : sps) {
                map.put(sp.getValue(), sp);
            }
            if (!map.isEmpty()) {
                builder.clearField(fd).setField(fd, (Object)Lists.newArrayList(map.values()));
            }
        }
    }

    private void setKeyValues(Message.Builder builder, String fieldName) {
        HashMap map = Maps.newHashMap();
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List kvs = (List)builder.getField(fd);
        if (kvs != null && !kvs.isEmpty()) {
            for (FieldTypeProtos.KeyValue sp : kvs) {
                map.put(sp.getKey(), sp);
            }
            if (!map.isEmpty()) {
                builder.clearField(fd).setField(fd, (Object)Lists.newArrayList(map.values()));
            }
        }
    }

    private void setSingleString(Message.Builder builder, String fieldName) {
        FieldTypeProtos.StringField s;
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List field = (List)builder.getField(fd);
        if (field != null && !field.isEmpty() && (s = (FieldTypeProtos.StringField)Iterables.getLast((Iterable)Iterables.filter((Iterable)field, this.skipEmptyStringField), (Object)"")) != null && s.getValue() != null && !s.getValue().isEmpty()) {
            builder.clearField(fd).setField(fd, (Object)Lists.newArrayList((Object[])new FieldTypeProtos.StringField[]{s}));
        }
    }

    private void setLongestStringField(Message.Builder builder, String fieldName) {
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List field = (List)builder.getField(fd);
        if (field != null && !field.isEmpty()) {
            FieldTypeProtos.StringField.Builder max = FieldTypeProtos.StringField.newBuilder().setValue("");
            int maxLength = 0;
            for (FieldTypeProtos.StringField sf : field) {
                if (sf.getValue().length() <= maxLength) continue;
                maxLength = sf.getValue().length();
                max.clear();
                max.mergeFrom(sf);
            }
            builder.clearField(fd).setField(fd, (Object)Lists.newArrayList((Object[])new FieldTypeProtos.StringField[]{max.build()}));
        }
    }

    private void setUniqueStringField(Message.Builder builder, String fieldName) {
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List field = (List)builder.getField(fd);
        HashMap map = Maps.newHashMap();
        if (field != null && !field.isEmpty()) {
            for (FieldTypeProtos.StringField s : Iterables.filter((Iterable)field, this.skipEmptyStringField)) {
                map.put(s.getValue(), s);
            }
            builder.clearField(fd).setField(fd, (Object)Lists.newArrayList(map.values()));
        }
    }

    private void setUniqueString(Message.Builder builder, String fieldName) {
        Descriptors.FieldDescriptor fd = builder.getDescriptorForType().findFieldByName(fieldName);
        List field = (List)builder.getField(fd);
        HashSet set = Sets.newHashSet();
        if (field != null && !field.isEmpty()) {
            for (String s : Iterables.filter((Iterable)field, this.skipEmptyString)) {
                set.add(s);
            }
            builder.clearField(fd).setField(fd, (Object)Lists.newArrayList((Iterable)set));
        }
    }

    private void setTitle(PublicationProtos.Publication.Metadata.Builder metadata) {
        Iterable filtered = Iterables.filter(metadata.getTitleList(), DNGFUtils.mainTitleFilter());
        if (!Iterables.isEmpty((Iterable)filtered)) {
            metadata.clearTitle().addTitle((FieldTypeProtos.StructuredProperty)Iterables.getLast((Iterable)filtered));
        }
    }

    private void setTitle(DatasetProtos.Dataset.Metadata.Builder metadata) {
        Iterable filtered = Iterables.filter(metadata.getTitleList(), DNGFUtils.mainTitleFilter());
        if (!Iterables.isEmpty((Iterable)filtered)) {
            metadata.clearTitle().addTitle((FieldTypeProtos.StructuredProperty)Iterables.getLast((Iterable)filtered));
        }
    }
}

