/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import com.google.common.base.Function;
import eu.dnetlib.data.graph.model.DNGFDecoder;
import eu.dnetlib.data.transform.Column;
import eu.dnetlib.data.transform.Row;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.DocumentResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class XsltRowTransformer
implements Function<String, List<Row>> {
    private static final Log log = LogFactory.getLog(XsltRowTransformer.class);
    public static final String DATA_XPATH = "/ROWS/ROW";
    public static final List<String> ATTRS = Arrays.asList("value", "mode");
    private Transformer transformer;

    public XsltRowTransformer(Transformer transformer) {
        this.transformer = transformer;
        log.info((Object)String.format("using trasformer: '%s'", this.getTransformerClassName()));
    }

    private List<Row> transform(String xml) {
        DocumentResult result = new DocumentResult();
        try {
            this.transformer.transform(new StreamSource(new StringReader(xml)), (Result)result);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(result.getDocument().asXML().getBytes()));
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("//ROW");
            NodeList evaluate = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            ArrayList<Row> resultRows = new ArrayList<Row>();
            for (int i = 0; i < evaluate.getLength(); ++i) {
                NamedNodeMap attributes = evaluate.item(i).getAttributes();
                if (attributes == null || attributes.getNamedItem("value") == null) continue;
                String value = attributes.getNamedItem("value").getTextContent();
                String mode = attributes.getNamedItem("mode") != null ? attributes.getNamedItem("mode").getTextContent() : null;
                resultRows.add(this.asRow(value, mode));
            }
            return resultRows;
        }
        catch (Exception e) {
            log.error((Object)("Error parsing xml:\n" + xml), (Throwable)e);
            throw new RuntimeException("Unable to parse document:\n" + xml, e);
        }
    }

    private Row asRow(String base64, String mode) {
        if (StringUtils.isBlank((CharSequence)base64)) {
            throw new IllegalArgumentException("empty protocolbuffer value, check xslt");
        }
        DNGFDecoder d = DNGFDecoder.decode(Base64.decodeBase64((String)base64));
        String qualifier = this.getQualifier(mode, d);
        return new Row(d.getColumnFamily(), d.getRowkey(), Collections.singletonList(new Column<String, byte[]>(qualifier, d.getDNGF().toByteArray())));
    }

    private String getQualifier(String mode, DNGFDecoder d) {
        if ("update".equals(mode)) {
            return "update_" + System.nanoTime();
        }
        return d.getQualifier();
    }

    public String getTransformerClassName() {
        return this.transformer != null ? this.transformer.getClass().getName() : "unknown";
    }

    public List<Row> apply(String xml) {
        return this.transform(xml);
    }
}

