/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.PublicationProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.CommonDNetXsltFunctions;
import eu.dnetlib.data.transform.xml.Element;
import eu.dnetlib.data.transform.xml.ElementList;
import eu.dnetlib.data.transform.xml.ValueMap;
import eu.dnetlib.pace.model.Person;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.NodeList;

public class OafToHbaseXsltFunctions
extends CommonDNetXsltFunctions {
    public static String oafPublication(String resultId, String provenance, String trust, NodeList about, String hostedbyId, String hostedbyName, String collectedFromId, String collectedFromName, String originalId, String dateOfCollection, String dateOfTransformation, NodeList nodelist) {
        try {
            String entityId = DNGFRowKeyDecoder.decode(resultId).getKey();
            ValueMap values = ValueMap.parseNodeList(nodelist);
            Descriptors.Descriptor mDesc = PublicationProtos.Publication.Metadata.getDescriptor();
            PublicationProtos.Publication.Metadata.Builder metadata = OafToHbaseXsltFunctions.buildMetadata(values, mDesc);
            PublicationProtos.Publication.Builder result = OafToHbaseXsltFunctions.buildPublication(metadata, values, mDesc, hostedbyId, hostedbyName);
            DNGFProtos.DNGFEntity.Builder entity = OafToHbaseXsltFunctions.buildOafEntity(result, entityId, nodelist, OafToHbaseXsltFunctions.getKV(collectedFromId, collectedFromName), originalId);
            entity.setDateofcollection(dateOfCollection).setDateoftransformation(dateOfTransformation).setOaiprovenance(OafToHbaseXsltFunctions.getOAIProvenance(about));
            DNGFProtos.DNGF oaf = OafToHbaseXsltFunctions.getOaf(entity, OafToHbaseXsltFunctions.getDataInfo(about, provenance, trust, false, false));
            return OafToHbaseXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Throwable e) {
            OafToHbaseXsltFunctions.handleException(e, resultId, hostedbyId, hostedbyName, provenance, trust, collectedFromId, collectedFromName, originalId, dateOfCollection);
            return null;
        }
    }

    public static String oafPublicationUpdate(String resultId, String provenance, String trust, NodeList nodelist, String hostedbyId, String hostedbyName) {
        try {
            String entityId = DNGFRowKeyDecoder.decode(resultId).getKey();
            ValueMap values = ValueMap.parseNodeList(nodelist);
            Descriptors.Descriptor mDesc = PublicationProtos.Publication.Metadata.getDescriptor();
            PublicationProtos.Publication.Metadata.Builder metadata = OafToHbaseXsltFunctions.buildMetadata(values, mDesc);
            PublicationProtos.Publication.Builder result = OafToHbaseXsltFunctions.buildPublication(metadata, values, mDesc, hostedbyId, hostedbyName);
            DNGFProtos.DNGFEntity.Builder entity = OafToHbaseXsltFunctions.buildOafEntity(result, entityId, nodelist, null, null);
            DNGFProtos.DNGF oaf = OafToHbaseXsltFunctions.getOaf(entity, null);
            return OafToHbaseXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Throwable e) {
            OafToHbaseXsltFunctions.handleException(e, resultId, hostedbyId, hostedbyName, provenance, trust, null, null, null, null);
            return null;
        }
    }

    private static DNGFProtos.DNGFEntity.Builder buildOafEntity(PublicationProtos.Publication.Builder pub, String entityId, NodeList nodelist, FieldTypeProtos.KeyValue collectedFrom, String originalId) {
        ArrayList pids = Lists.newArrayList();
        pids.addAll(OafToHbaseXsltFunctions.parsePids(nodelist));
        DNGFProtos.DNGFEntity.Builder entity = OafToHbaseXsltFunctions.getEntity(TypeProtos.Type.publication, entityId, collectedFrom, StringUtils.isBlank((CharSequence)originalId) ? null : Lists.newArrayList((Object[])new String[]{originalId}), null, null, pids).setPublication(pub);
        return entity;
    }

    protected static PublicationProtos.Publication.Metadata.Builder buildMetadata(ValueMap values, Descriptors.Descriptor mDesc) {
        PublicationProtos.Publication.Metadata.Builder metadata = PublicationProtos.Publication.Metadata.newBuilder();
        OafToHbaseXsltFunctions.addStructuredProps((Message.Builder)metadata, mDesc.findFieldByName("subject"), values.get("subject").listValues(), "keyword", "dnet:result_subject");
        OafToHbaseXsltFunctions.addStructuredProps((Message.Builder)metadata, mDesc.findFieldByName("title"), values.get("title").listValues(), "main title", "dnet:dataCite_title");
        for (String fieldname : Lists.newArrayList((Object[])new String[]{"description", "source", "contributor"})) {
            if (values.get(fieldname) == null) continue;
            for (String s : values.get(fieldname).listValues()) {
                OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName(fieldname), s);
            }
        }
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("language"), OafToHbaseXsltFunctions.setQualifier(OafToHbaseXsltFunctions.getDefaultQualifier("dnet:languages"), values.get("language").listValues()));
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("dateofacceptance"), values.get("dateaccepted").listValues());
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("publisher"), values.get("publisher").listValues());
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("embargoenddate"), values.get("embargoenddate").listValues());
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("storagedate"), values.get("storagedate").listValues());
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("resulttype"), OafToHbaseXsltFunctions.getSimpleQualifier("publication", "dnet:result_typologies"));
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("fulltext"), values.get("fulltext").listValues());
        OafToHbaseXsltFunctions.addField((Message.Builder)metadata, mDesc.findFieldByName("format"), values.get("format").listValues());
        if (values.get("concept") != null) {
            for (Element e : values.get("concept")) {
                String id = e.getAttributes().get("id");
                if (StringUtils.isBlank((CharSequence)id)) {
                    throw new IllegalArgumentException("Context id cannot be blank");
                }
                metadata.addContext(FieldTypeProtos.Context.newBuilder().setId(id));
            }
        }
        if (values.get("journal") != null) {
            for (Element e : values.get("journal")) {
                Map<String, String> attr;
                FieldTypeProtos.Journal.Builder journal = FieldTypeProtos.Journal.newBuilder();
                if (e.getText() != null) {
                    journal.setName(e.getText());
                }
                if ((attr = e.getAttributes()) != null) {
                    if (attr.get("issn") != null) {
                        journal.setIssnPrinted(attr.get("issn"));
                    }
                    if (attr.get("eissn") != null) {
                        journal.setIssnOnline(attr.get("eissn"));
                    }
                    if (attr.get("lissn") != null) {
                        journal.setIssnLinking(attr.get("lissn"));
                    }
                }
                metadata.setJournal(journal.build());
            }
        }
        return metadata;
    }

    protected static PublicationProtos.Publication.Builder buildPublication(PublicationProtos.Publication.Metadata.Builder metadata, ValueMap values, Descriptors.Descriptor mDesc, String hostedbyId, String hostedbyName) {
        PublicationProtos.Publication.Builder result = PublicationProtos.Publication.newBuilder();
        if (values.get("creator") != null) {
            for (String fullname : values.get("creator").listValues()) {
                PersonProtos.Person.Metadata.Builder authorMetadata = PersonProtos.Person.Metadata.newBuilder();
                authorMetadata.setFullname(OafToHbaseXsltFunctions.sf(fullname));
                Person p = new Person(fullname, false);
                if (p.isAccurate()) {
                    authorMetadata.setFirstname(OafToHbaseXsltFunctions.sf(p.getNormalisedFirstName()));
                    authorMetadata.clearSecondnames().addSecondnames(OafToHbaseXsltFunctions.sf(p.getNormalisedSurname()));
                    authorMetadata.setFullname(OafToHbaseXsltFunctions.sf(p.getNormalisedFullname()));
                }
                result.addAuthor(PersonProtos.Person.newBuilder().setMetadata(authorMetadata));
            }
        }
        FieldTypeProtos.Instance.Builder instance = FieldTypeProtos.Instance.newBuilder().setHostedby(OafToHbaseXsltFunctions.getKV(hostedbyId, hostedbyName));
        OafToHbaseXsltFunctions.addField((Message.Builder)instance, FieldTypeProtos.Instance.getDescriptor().findFieldByName("licence"), OafToHbaseXsltFunctions.setQualifier(OafToHbaseXsltFunctions.getDefaultQualifier("dnet:access_modes"), values.get("accessrights").listValues()));
        OafToHbaseXsltFunctions.addField((Message.Builder)instance, FieldTypeProtos.Instance.getDescriptor().findFieldByName("instancetype"), OafToHbaseXsltFunctions.setQualifier(OafToHbaseXsltFunctions.getDefaultQualifier("dnet:publication_resource"), values.get("cobjcategory").listValues()));
        if (values.get("identifier") != null) {
            OafToHbaseXsltFunctions.addField((Message.Builder)instance, FieldTypeProtos.Instance.getDescriptor().findFieldByName("url"), Lists.newArrayList((Iterable)Iterables.filter(values.get("identifier").listValues(), (Predicate)urlFilter)));
        }
        result.addInstance(instance);
        ElementList extrefs = values.get("reference");
        if (!extrefs.isEmpty()) {
            Descriptors.Descriptor extDesc = FieldTypeProtos.ExternalReference.getDescriptor();
            for (Element element : extrefs) {
                FieldTypeProtos.ExternalReference.Builder extref = FieldTypeProtos.ExternalReference.newBuilder();
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("url"), element.getText());
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("sitename"), element.getAttributes().get("source"));
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("refidentifier"), element.getAttributes().get("identifier"));
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("label"), element.getAttributes().get("title"));
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("query"), element.getAttributes().get("query"));
                OafToHbaseXsltFunctions.addField((Message.Builder)extref, extDesc.findFieldByName("qualifier"), OafToHbaseXsltFunctions.setQualifier(OafToHbaseXsltFunctions.getDefaultQualifier("dnet:externalReference_typologies"), Lists.newArrayList((Object[])new String[]{element.getAttributes().get("type")})).build());
                result.addExternalReference(extref);
            }
        }
        return result.setMetadata(metadata);
    }

    private static void handleException(Throwable e, String resultId, String hostedbyId, String hostedbyName, String provenance, String trust, String collectedFromId, String collectedFromName, String originalId, String dateOfCollection) {
        System.err.println("resultId: " + resultId);
        if (StringUtils.isNotBlank((CharSequence)hostedbyId)) {
            System.err.println("hostedbyId: " + hostedbyId);
        }
        if (StringUtils.isNotBlank((CharSequence)hostedbyName)) {
            System.err.println("hostedbyName: " + hostedbyName);
        }
        if (StringUtils.isNotBlank((CharSequence)provenance)) {
            System.err.println("provenance: " + provenance);
        }
        if (StringUtils.isNotBlank((CharSequence)trust)) {
            System.err.println("trust: " + trust);
        }
        if (StringUtils.isNotBlank((CharSequence)collectedFromId)) {
            System.err.println("collectedFromId: " + collectedFromId);
        }
        if (StringUtils.isNotBlank((CharSequence)collectedFromName)) {
            System.err.println("collectedFromName: " + collectedFromName);
        }
        if (StringUtils.isNotBlank((CharSequence)originalId)) {
            System.err.println("originalId: " + originalId);
        }
        if (StringUtils.isNotBlank((CharSequence)dateOfCollection)) {
            System.err.println("dateOfCollection: " + dateOfCollection);
        }
        e.printStackTrace();
        throw new RuntimeException(e);
    }
}

