/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.graph.model;

import eu.dnetlib.data.proto.TypeProtos;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DNGFRowKeyDecoder {
    public static final String ID_REGEX = "^[0-9][0-9]\\|.{12}::[a-zA-Z0-9]{32}$";
    private static final Log log = LogFactory.getLog(DNGFRowKeyDecoder.class);
    private static final String SEPARATOR = "|";
    private String key;
    private TypeProtos.Type type = null;
    private String id = null;

    private DNGFRowKeyDecoder(String key) throws IllegalArgumentException {
        this.key = key;
        if (!key.matches(ID_REGEX)) {
            String msg = "invalid key: '" + key + "'";
            log.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        int tag = Integer.parseInt(StringUtils.substringBefore((String)key, (String)SEPARATOR));
        this.type = TypeProtos.Type.valueOf(tag);
        this.id = StringUtils.substringAfter((String)key, (String)SEPARATOR);
    }

    public static DNGFRowKeyDecoder decode(byte[] key) throws IllegalArgumentException {
        return new DNGFRowKeyDecoder(new String(key));
    }

    public static DNGFRowKeyDecoder decode(String key) throws IllegalArgumentException {
        return new DNGFRowKeyDecoder(key);
    }

    public String getKey() {
        return this.key;
    }

    public TypeProtos.Type getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }
}

