/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform;

import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.transform.Ontology;
import eu.dnetlib.data.transform.OntologyTerm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Ontologies
extends HashMap<String, Ontology> {
    private static final Log log = LogFactory.getLog(Ontologies.class);
    private Map<String, List<OntologyTerm>> inverse = Maps.newHashMap();

    public String inverseOf(RelDescriptor rd) {
        if (!this.containsKey(rd.getOntologyCode())) {
            log.debug((Object)String.format("unable to find ontology '%s'", rd.getOntologyCode()));
            return null;
        }
        return ((Ontology)this.get(rd.getOntologyCode())).inverseOf(rd.getTermCode());
    }

    public List<OntologyTerm> getTerms(String termCode) {
        if (this.inverse.isEmpty()) {
            this.initInverse();
        }
        return this.inverse.get(termCode);
    }

    private void initInverse() {
        log.info((Object)"initialising inverse Ontology terms");
        this.values().forEach((? super T o) -> o.getTerms().values().forEach((? super T t) -> {
            if (!this.inverse.containsKey(t.getCode())) {
                this.inverse.put(t.getCode(), new ArrayList());
            }
            this.inverse.get(t.getCode()).add((OntologyTerm)t);
        }));
    }

    public String toJson() {
        return this.toJson(false);
    }

    public String toJson(boolean pretty) {
        GsonBuilder gson = new GsonBuilder();
        if (pretty) {
            gson.setPrettyPrinting();
        }
        return gson.create().toJson((Object)this);
    }

    @Override
    public String toString() {
        return this.toJson();
    }
}

