/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transform.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Message;
import eu.dnetlib.data.graph.model.DNGFRowKeyDecoder;
import eu.dnetlib.data.graph.utils.RelDescriptor;
import eu.dnetlib.data.proto.DNGFProtos;
import eu.dnetlib.data.proto.DatasetProtos;
import eu.dnetlib.data.proto.FieldTypeProtos;
import eu.dnetlib.data.proto.PersonProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.pace.model.Person;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommonDNetXsltFunctions
extends AbstractDNetXsltFunctions {
    private static final int MAX_COAUTHORS = 50;

    public static String authorship(String source, String target, int rank, String relTypeId, String relTypeScheme, String provenanceAction, String trust, NodeList about) {
        HashMap params = Maps.newHashMap();
        params.put("rank", "" + rank);
        return CommonDNetXsltFunctions.rel(source, target, relTypeId, relTypeScheme, provenanceAction, trust, about, params);
    }

    public static String rel(String source, String target, String relTypeId, String relTypeScheme, String provenanceAction, String trust) {
        return CommonDNetXsltFunctions.rel(source, target, relTypeId, relTypeScheme, provenanceAction, trust, null, null);
    }

    public static String rel(String source, String target, String relTypeId, String relTypeScheme, String provenanceAction, String trust, NodeList about) {
        return CommonDNetXsltFunctions.rel(source, target, relTypeId, relTypeScheme, provenanceAction, trust, about, null);
    }

    public static String rel(String source, String target, String relTypeId, String relTypeScheme, String provenanceAction, String trust, NodeList about, Map<String, String> params) {
        try {
            DNGFProtos.DNGFRel.Builder rel = CommonDNetXsltFunctions.relProto(source, target, relTypeId, relTypeScheme);
            DNGFProtos.DNGF oaf = CommonDNetXsltFunctions.getOaf(rel, CommonDNetXsltFunctions.getDataInfo(about, provenanceAction, trust, false, false));
            return CommonDNetXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    protected static DNGFProtos.DNGFRel.Builder relProto(String source, String target, String relTypeId, String relTypeScheme) {
        try {
            DNGFRowKeyDecoder sd = DNGFRowKeyDecoder.decode(source);
            DNGFRowKeyDecoder td = DNGFRowKeyDecoder.decode(target);
            FieldTypeProtos.Qualifier.Builder relType = CommonDNetXsltFunctions.getSimpleQualifier(relTypeId, relTypeScheme);
            DNGFProtos.DNGFRel.Builder rel = CommonDNetXsltFunctions.getRel(sd.getKey(), sd.getType(), td.getKey(), td.getType(), relType.build(), false);
            return rel;
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
    }

    public static String person(String personId, NodeList about, String provenanceAction, String trust, String collectedFromId, String collectedFromName, String originalId, String dateOfCollection, String dateOfTransformation, String fullname, String nameIdentifier, String nameIdentifierScheme) {
        return CommonDNetXsltFunctions.person(personId, fullname, nameIdentifier, nameIdentifierScheme, null, null, null, provenanceAction, trust, about, collectedFromId, collectedFromName, originalId, dateOfCollection, dateOfTransformation);
    }

    public static String person(String personId, String fullname, String nameIdentifier, String nameIdentifierScheme, NodeList authors, String namespaceprefix, String objIdentifier, String provenanceAction, String trust, NodeList about, String collectedFromId, String collectedFromName, String originalId, String dateOfCollection, String dateOfTransformation) {
        try {
            String entityId = DNGFRowKeyDecoder.decode(personId).getKey();
            PersonProtos.Person.Builder person = PersonProtos.Person.newBuilder();
            PersonProtos.Person.Metadata.Builder metadata = CommonDNetXsltFunctions.getMetadata(fullname);
            if (authors != null) {
                for (int i = 0; i < authors.getLength() && i < 50; ++i) {
                    Node node = authors.item(i);
                    String name = StringUtils.trim((String)node.getTextContent());
                    if (name.equals(fullname)) continue;
                    PersonProtos.Person.CoAuthor.Builder coAuthor = PersonProtos.Person.CoAuthor.newBuilder();
                    coAuthor.setId(CommonDNetXsltFunctions.oafId("person", namespaceprefix, objIdentifier + "::" + name));
                    coAuthor.setMetadata(CommonDNetXsltFunctions.getMetadata(name));
                    person.addCoauthor(coAuthor);
                }
            }
            ArrayList pids = Lists.newArrayList();
            if (StringUtils.isNotBlank((CharSequence)nameIdentifier) && StringUtils.isNotBlank((CharSequence)nameIdentifierScheme)) {
                pids.add(CommonDNetXsltFunctions.getStructuredProperty(nameIdentifier, nameIdentifierScheme, nameIdentifierScheme, "dnet:pid_types", "dnet:pid_types"));
            }
            DNGFProtos.DNGFEntity.Builder entity = CommonDNetXsltFunctions.getEntity(TypeProtos.Type.person, entityId, CommonDNetXsltFunctions.getKV(collectedFromId, collectedFromName), Lists.newArrayList((Object[])new String[]{originalId}), dateOfCollection, dateOfTransformation, pids).setPerson(person.setMetadata(metadata));
            DNGFProtos.DNGF oaf = CommonDNetXsltFunctions.getOaf(entity, CommonDNetXsltFunctions.getDataInfo(about, provenanceAction, trust, false, false));
            return CommonDNetXsltFunctions.base64(oaf.toByteArray());
        }
        catch (Throwable e) {
            System.err.println("personId: " + personId);
            System.err.println("fullname: " + fullname);
            System.err.println("provenanceAction: " + provenanceAction);
            System.err.println("trust: " + trust);
            System.err.println("collectedFromId: " + collectedFromId);
            System.err.println("collectedFromName: " + collectedFromName);
            System.err.println("originalId: " + originalId);
            System.err.println("dateOfCollection: " + dateOfCollection);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static PersonProtos.Person.Metadata.Builder getMetadata(String fullname) {
        PersonProtos.Person.Metadata.Builder metadata = PersonProtos.Person.Metadata.newBuilder();
        metadata.setFullname(CommonDNetXsltFunctions.sf(fullname));
        Person p = new Person(fullname, false);
        if (p.isAccurate()) {
            metadata.setFirstname(CommonDNetXsltFunctions.sf(p.getNormalisedFirstName()));
            metadata.clearSecondnames().addSecondnames(CommonDNetXsltFunctions.sf(p.getNormalisedSurname()));
        }
        return metadata;
    }

    protected static void manageTitle(NodeList titles, DatasetProtos.Dataset.Metadata.Builder metadataProto) {
        for (int i = 0; i < titles.getLength(); ++i) {
            Node currentNode = titles.item(i);
            NodeList childNodes = currentNode.getChildNodes();
            if (childNodes.getLength() <= 0) continue;
            String titleValue = childNodes.item(0).getNodeValue();
            String classname = "main title";
            String classid = "main title";
            if (currentNode.hasAttributes()) {
                NamedNodeMap attributes = currentNode.getAttributes();
                Node titleType = attributes.getNamedItem("titleType");
                if (titleType != null && titleType.getNodeValue().equals("AlternativeTitle")) {
                    classname = "alternative title";
                    classid = "alternative title";
                }
                if (titleType != null && titleType.getNodeValue().equals("Subtitle")) {
                    classname = "subtitle";
                    classid = "subtitle";
                }
                if (titleType != null && titleType.getNodeValue().equals("TranslatedTitle")) {
                    classname = "translated title";
                    classid = "translated title";
                }
            }
            CommonDNetXsltFunctions.addField((Message.Builder)metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName("title"), CommonDNetXsltFunctions.getStructuredProperty(titleValue, classname, classid, "dnet:dataCite_title", "dnet:dataCite_title"));
        }
    }

    public static String relQualifier(String ontology, String termCode, String targetId) {
        return new RelDescriptor(ontology, termCode, targetId).qualifier();
    }

    protected static void manageDate(NodeList dates, DatasetProtos.Dataset.Metadata.Builder metadataProto) {
        for (int i = 0; i < dates.getLength(); ++i) {
            Node currentNode = dates.item(i);
            if (currentNode == null || !currentNode.hasAttributes() || !currentNode.hasChildNodes()) continue;
            String dateAttribute = currentNode.getAttributes().getNamedItem("dateType").getNodeValue();
            String dateValue = currentNode.getChildNodes().item(0).getNodeValue();
            String protoAttribute = "relevantdate";
            if ("Accepted".equals(dateAttribute)) {
                protoAttribute = "dateofacceptance";
            } else if ("Issued".equals(dateAttribute)) {
                protoAttribute = "storagedate";
            } else if ("Updated".equals(dateAttribute)) {
                protoAttribute = "lastmetadataupdate";
            } else if ("Available".equals(dateAttribute)) {
                protoAttribute = "embargoenddate";
            }
            if (!protoAttribute.equals("relevantdate")) {
                CommonDNetXsltFunctions.addField((Message.Builder)metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName(protoAttribute), dateValue);
                continue;
            }
            CommonDNetXsltFunctions.addField((Message.Builder)metadataProto, DatasetProtos.Dataset.Metadata.getDescriptor().findFieldByName(protoAttribute), CommonDNetXsltFunctions.getStructuredProperty(dateValue, "UNKNOWN", "UNKNOWN", "dnet:dataCite_date", "dnet:dataCite_date"));
        }
    }

    public static String getFirstItem(NodeList list) {
        String out = "";
        if (list != null && list.getLength() > 0 && list.item(0).getChildNodes() != null && list.item(0).getChildNodes().getLength() > 0) {
            out = list.item(0).getChildNodes().item(0).getNodeValue();
        }
        return out;
    }
}

