package eu.dnetlib.msro.workflows.nodes.info;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.datasource.DatasourceManagerService;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class ObjectStoreToApiExtraFieldJobNode extends SimpleJobNode {

	private String objId;
	private String datasourceId;
	private String datasourceInterface;
	private String extraFieldForTotal;
	private String extraFieldForDate;
	private String extraFieldForObjId;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {
		final String xq = "for $x in collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType') " + "where $x//RESOURCE_IDENTIFIER/@value='"
				+ this.objId + "' " + "return concat($x//COUNT_STORE, ' @=@ ', $x//LAST_STORAGE_DATE)";

		final String s = this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xq);

		final String[] arr = s.split(" @=@ ");

		final Map<String, String> map = getCurrentExtraFields(this.datasourceId, this.datasourceInterface);
		map.put(this.extraFieldForTotal, arr[0].trim());
		map.put(this.extraFieldForDate, arr[1].trim());
		map.put(this.extraFieldForObjId, this.objId);

		this.serviceLocator.getService(DatasourceManagerService.class).bulkUpdateApiExtraFields(this.datasourceId, this.datasourceInterface, map);

		return Arc.DEFAULT_ARC;
	}

	private Map<String, String> getCurrentExtraFields(final String repoId, final String ifaceId) throws Exception {
		final Map<String, String> res = new HashMap<>();

		final String profile = this.serviceLocator.getService(ISLookUpService.class).getResourceProfile(repoId);

		final SAXReader reader = new SAXReader();
		final Document doc = reader.read(new StringReader(profile));

		final Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']");
		if (ifcNode != null) {
			for (final Object o : ifcNode.selectNodes("./INTERFACE_EXTRA_FIELD")) {
				res.put(((Node) o).valueOf("@name"), ((Node) o).getText());
			}
		}

		return res;
	}

	public String getDatasourceId() {
		return this.datasourceId;
	}

	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getDatasourceInterface() {
		return this.datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}

	public String getExtraFieldForTotal() {
		return this.extraFieldForTotal;
	}

	public void setExtraFieldForTotal(final String extraFieldForTotal) {
		this.extraFieldForTotal = extraFieldForTotal;
	}

	public String getExtraFieldForDate() {
		return this.extraFieldForDate;
	}

	public void setExtraFieldForDate(final String extraFieldForDate) {
		this.extraFieldForDate = extraFieldForDate;
	}

	/**
	 * @return the objId
	 */
	public String getObjId() {
		return this.objId;
	}

	/**
	 * @param objId
	 *            the objId to set
	 */
	public void setObjId(final String objId) {
		this.objId = objId;
	}

	/**
	 * @return the extraFieldForObjId
	 */
	public String getExtraFieldForObjId() {
		return this.extraFieldForObjId;
	}

	/**
	 * @param extraFieldForObjId
	 *            the extraFieldForObjId to set
	 */
	public void setExtraFieldForObjId(final String extraFieldForObjId) {
		this.extraFieldForObjId = extraFieldForObjId;
	}

}
