/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.xmlvalidation;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.InputSource;

public class SchemaVerifierJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(SchemaVerifierJobNode.class);
    private String expectedSchemaURL;
    private boolean enableVerification;
    private String eprParam;
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSD_LOCATION = "xsi:schemaLocation";
    private static final String XSD_NO_NS_LOCATION = "xsi:noNamespaceSchemaLocation";
    @Autowired
    private ResultSetClient resultSetClient;
    private Processor xmlProcessor = new Processor(false);
    private XPathSelector xpathSelectorSchema;
    private XPathSelector xpathSelectorSchemaNoNS;
    private XPathSelector xpathSelectorId;

    @Override
    protected String execute(Env env) throws Exception {
        if (this.enableVerification) {
            ResultSet rsIn = env.getAttribute(this.eprParam, ResultSet.class);
            if (rsIn == null) {
                throw new MSROException("InputEprParam (" + this.eprParam + ") not found in ENV");
            }
            this.prepareXpath();
            Iterable records = this.resultSetClient.iter(rsIn, String.class);
            for (String record : records) {
                this.verifySchema(record);
            }
        }
        return Arc.DEFAULT_ARC;
    }

    private void prepareXpath() throws SaxonApiException {
        XPathCompiler compiler = this.xmlProcessor.newXPathCompiler();
        compiler.declareNamespace("xsi", XSI_NS);
        XPathExecutable xpathSchema = compiler.compile("@xsi:schemaLocation");
        this.xpathSelectorSchema = xpathSchema.load();
        XPathExecutable xpathSchemaNoNS = compiler.compile("@xsi:noNamespaceSchemaLocation");
        this.xpathSelectorSchemaNoNS = xpathSchemaNoNS.load();
        XPathExecutable xpathID = compiler.compile("//*[local-name()='objIdentifier']");
        this.xpathSelectorId = xpathID.load();
    }

    private void verifySchema(String record) throws SaxonApiException {
        String schema;
        SAXSource source = new SAXSource(new InputSource(new StringReader(record)));
        DocumentBuilder docBuilder = this.xmlProcessor.newDocumentBuilder();
        XdmNode xdmNode = docBuilder.build((Source)source);
        this.xpathSelectorId.setContextItem((XdmItem)xdmNode);
        XdmItem objidItem = this.xpathSelectorId.evaluateSingle();
        if (objidItem == null) {
            throw new RuntimeException("Record with no objIdentifier");
        }
        String objid = objidItem.getStringValue();
        this.xpathSelectorSchema.setContextItem((XdmItem)xdmNode);
        XdmItem res = this.xpathSelectorSchema.evaluateSingle();
        if (res == null) {
            this.xpathSelectorSchemaNoNS.setContextItem((XdmItem)xdmNode);
            res = this.xpathSelectorSchemaNoNS.evaluateSingle();
            if (res == null) {
                log.warn((Object)("Record " + objid + " has no " + XSD_LOCATION + " nor " + XSD_NO_NS_LOCATION));
            }
        }
        if (res != null && !(schema = res.getStringValue()).equalsIgnoreCase(this.expectedSchemaURL)) {
            log.warn((Object)("Record " + objid + " has XSD: " + schema + ". Expected schema: " + this.expectedSchemaURL));
        }
    }

    public String getExpectedSchemaURL() {
        return this.expectedSchemaURL;
    }

    public void setExpectedSchemaURL(String expectedSchemaURL) {
        this.expectedSchemaURL = expectedSchemaURL;
    }

    public boolean isEnableVerification() {
        return this.enableVerification;
    }

    public void setEnableVerification(boolean enableVerification) {
        this.enableVerification = enableVerification;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }
}

