package eu.dnetlib.msro.workflows.nodes.misc;

import java.nio.charset.Charset;
import java.util.List;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class FindVocabularyEntriesJobNode extends SimpleJobNode {

	private String outputEprParam = "epr";

	@javax.annotation.Resource
	private UniqueServiceLocator serviceLocator;

	@Autowired
	private ResultSetFactory resultSetFactory;

	private Resource xquery;

	@Override
	protected String execute(final Env env) throws Exception {
		final String query = IOUtils.toString(xquery.getInputStream(), Charset.forName("UTF-8"));
		final List<String> terms = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(query);
		final ResultSet<String> resultSet = resultSetFactory.createResultSet(terms);
		env.setAttribute(getOutputEprParam(), resultSet);
		return Arc.DEFAULT_ARC;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public Resource getXquery() {
		return xquery;
	}

	@Required
	public void setXquery(final Resource xquery) {
		this.xquery = xquery;
	}

}
