/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.graph;

import java.util.List;
import java.util.Map;

public class GraphNodeParameter {
    private final Object value;
    private final String envVariable;

    private GraphNodeParameter(Object value, String envVariable) {
        this.value = value;
        this.envVariable = envVariable;
    }

    public static GraphNodeParameter newNullParam() {
        return new GraphNodeParameter(null, null);
    }

    public static GraphNodeParameter newSimpleParam(Object value) {
        return new GraphNodeParameter(value, null);
    }

    public static GraphNodeParameter newMapParam(Map<String, GraphNodeParameter> map) {
        return new GraphNodeParameter(map, null);
    }

    public static GraphNodeParameter newListParam(List<GraphNodeParameter> list) {
        return new GraphNodeParameter(list, null);
    }

    public static GraphNodeParameter newEnvParam(String envVariable) {
        return new GraphNodeParameter(null, envVariable);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isEnvParam() {
        return this.envVariable != null;
    }

    public String getEnvVariable() {
        return this.envVariable;
    }

    public boolean isMap() {
        return this.value != null && this.value instanceof Map;
    }

    public boolean isList() {
        return this.value != null && this.value instanceof List;
    }
}

