/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.ProcessNode;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.ProcessRegistry;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.procs.WorkflowExecutor;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.msro.workflows.util.ProcessCallback;
import eu.dnetlib.msro.workflows.util.SubWorkflowProgressProvider;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LaunchWorkflowTemplateJobNode
extends ProcessNode
implements ProcessAware {
    private static final Log log = LogFactory.getLog(LaunchWorkflowTemplateJobNode.class);
    private String wfTemplateId;
    private Map<String, String> wfTemplateParams;
    private WorkflowProcess process;
    @Autowired
    private WorkflowExecutor executor;
    @Autowired
    private ProcessRegistry processRegistry;

    public Map<String, String> getWfTemplateParams() {
        return this.wfTemplateParams;
    }

    public void setWfTemplateParams(Map<String, String> wfTemplateParams) {
        this.wfTemplateParams = wfTemplateParams;
    }

    @Override
    public final void execute(final Token token) {
        try {
            String family = this.process.getFamily();
            int priority = this.process.getPriority();
            String dsId = this.process.getDsId();
            String iface = this.process.getDsInterface();
            String procId = this.executor.startWorkflowTemplate(this.getWfTemplateId(), this.getNodeName(), family, priority, dsId, iface, this.wfTemplateParams, new ProcessCallback(){

                @Override
                public void onSuccess() {
                    log.debug((Object)"Child workflow has been completed successfully");
                    token.setNextArc(Arc.DEFAULT_ARC);
                    token.release();
                }

                @Override
                public void onFail() {
                    log.error((Object)"Child workflow is failed");
                    token.releaseAsFailed("Child workflow is failed");
                }
            }, this.process.getProfileId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("The child workflow [" + this.getNodeName() + "] is starting with procId: " + procId));
            }
            token.setProgressProvider(new SubWorkflowProgressProvider(procId, this.processRegistry));
        }
        catch (Throwable e) {
            log.error((Object)"got exception while launching child workflow", e);
            token.releaseAsFailed(e);
        }
    }

    public String getWfTemplateId() {
        return this.wfTemplateId;
    }

    public void setWfTemplateId(String wfTemplateId) {
        this.wfTemplateId = wfTemplateId;
    }

    public WorkflowProcess getProcess() {
        return this.process;
    }

    @Override
    public void setProcess(WorkflowProcess process) {
        this.process = process;
    }
}

