package eu.dnetlib.msro.workflows.nodes.mdstore;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.MDStoreService;

public class DeleteMDStoreJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(DeleteMDStoreJobNode.class);

	private String mdstoreId;

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(MDStoreService.class, this.mdstoreId);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) {
		log.info("preparing blackboard job: delete of mdstore " + getMdstoreId());
		job.setAction("DELETE");
		job.getParameters().put("id", getMdstoreId());
	}

	public String getMdstoreId() {
		return this.mdstoreId;
	}

	public void setMdstoreId(final String mdstoreId) {
		this.mdstoreId = mdstoreId;
	}

}
