package eu.dnetlib.msro.workflows.nodes.mdstore;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class VerifyMDStoreJobNode extends SimpleJobNode {

	private String format;
	private String layout;
	private String interpretation;
	private String outputPrefix;
	private String onFailed;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {

		final String query = String.format(
				"collection('/db/DRIVER/MDStoreDSResources/MDStoreDSResourceType')[normalize-space(.//METADATA_FORMAT) = '%s' and normalize-space(.//METADATA_FORMAT_LAYOUT = '%s') and normalize-space(.//METADATA_FORMAT_INTERPRETATION) = '%s']//RESOURCE_IDENTIFIER/@value/string()",
				format.trim(), layout.trim(), interpretation.trim());

		try {
			final String id = serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(query);

			env.setAttribute(outputPrefix + "format", format);
			env.setAttribute(outputPrefix + "layout", layout);
			env.setAttribute(outputPrefix + "interpretation", interpretation);
			env.setAttribute(outputPrefix + "id", id);

			return Arc.DEFAULT_ARC;
		} catch (final ISLookUpDocumentNotFoundException e) {
			if (StringUtils.isNotBlank(onFailed)) {
				return onFailed;
			} else {
				throw e;
			}
		}
	}

	public String getFormat() {
		return format;
	}

	public void setFormat(final String format) {
		this.format = format;
	}

	public String getLayout() {
		return layout;
	}

	public void setLayout(final String layout) {
		this.layout = layout;
	}

	public String getInterpretation() {
		return interpretation;
	}

	public void setInterpretation(final String interpretation) {
		this.interpretation = interpretation;
	}

	public String getOutputPrefix() {
		return outputPrefix;
	}

	public void setOutputPrefix(final String outputPrefix) {
		this.outputPrefix = outputPrefix;
	}

	public String getOnFailed() {
		return onFailed;
	}

	public void setOnFailed(final String onFailed) {
		this.onFailed = onFailed;
	}

}
