/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.db;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DatabaseService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdateDbJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(UpdateDbJobNode.class);
    private String db;
    private String dbParam;
    private String eprParam;
    @Autowired
    private ResultSetClient resultSetClient;

    @Override
    protected String obtainServiceId(Env env) {
        return this.getServiceLocator().getServiceId(DatabaseService.class);
    }

    @Override
    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        if (this.db == null || this.db.isEmpty()) {
            this.db = token.getEnv().getAttribute(this.getDbParam(), String.class);
        }
        log.info((Object)("preparing blackboard job to update DB: " + this.db));
        ResultSet rs = token.getEnv().getAttribute(this.getEprParam(), ResultSet.class);
        token.setProgressProvider(new ResultsetProgressProvider(rs, this.resultSetClient));
        job.setAction("IMPORT");
        job.getParameters().put("db", this.db);
        job.getParameters().put("epr", rs.toJson());
    }

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getDbParam() {
        return this.dbParam;
    }

    public void setDbParam(String dbParam) {
        this.dbParam = dbParam;
    }
}

