/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.mdstore;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MDStoreService;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FetchMDStoreRecordsJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(FetchMDStoreRecordsJobNode.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String mdId;
    private String eprParam;
    private boolean noCursorTimeout = false;
    private String fromDate;
    private String untilDate;

    @Override
    protected String execute(Env env) throws Exception {
        boolean refresh;
        if (this.getMdId() == null) {
            this.setMdId(env.getAttribute("mdId", String.class));
        }
        boolean bl = refresh = StringUtils.isBlank((CharSequence)this.fromDate) && StringUtils.isBlank((CharSequence)this.untilDate);
        if (refresh) {
            log.info((Object)("Getting MDRecords from: " + this.getMdId() + " with noCursorTimeout == " + this.isNoCursorTimeout()));
        } else {
            log.info((Object)("Getting MDRecords from: " + this.getMdId() + " with noCursorTimeout == " + this.isNoCursorTimeout() + ". Incremental from " + this.fromDate + " until " + this.untilDate));
        }
        ResultSet rs = this.noCursorTimeout ? ((MDStoreService)this.serviceLocator.getService(MDStoreService.class, this.getMdId())).deliverMDRecordsNoCursorTimeout(this.getMdId(), this.fromDate, this.untilDate, "") : ((MDStoreService)this.serviceLocator.getService(MDStoreService.class, this.getMdId())).deliverMDRecords(this.getMdId(), this.fromDate, this.untilDate, "");
        if (rs == null) {
            throw new MSROException("unable to read MDRecords from: " + this.getMdId());
        }
        env.setAttribute(this.getEprParam(), rs);
        return Arc.DEFAULT_ARC;
    }

    public String getMdId() {
        return this.mdId;
    }

    public void setMdId(String mdId) {
        this.mdId = mdId;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public void setNoCursorTimeout(boolean noCursorTimeout) {
        this.noCursorTimeout = noCursorTimeout;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public String getUntilDate() {
        return this.untilDate;
    }

    public void setUntilDate(String untilDate) {
        this.untilDate = untilDate;
    }
}

