/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.mdstore;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.MDStoreService;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RunMDStorePluginJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(RunMDStorePluginJobNode.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String pluginName;
    @Deprecated
    private String mdId;
    private Map<String, String> parameters = new HashMap<String, String>();

    @Override
    protected String obtainServiceId(Env env) {
        return this.serviceLocator.getServiceId(MDStoreService.class);
    }

    @Override
    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        job.setAction("RUN_PLUGIN");
        if (!StringUtils.isNotBlank((CharSequence)this.pluginName)) {
            log.error((Object)"pluginName is empty");
            throw new MSROException("pluginName is empty");
        }
        job.getParameters().put("plugin.name", this.pluginName);
        if (StringUtils.isNotBlank((CharSequence)this.mdId)) {
            job.getParameters().put("mdId", this.mdId);
        }
        if (this.parameters != null) {
            job.getParameters().putAll(this.parameters);
        }
        log.debug((Object)job.getParameters());
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Deprecated
    public String getMdId() {
        return this.mdId;
    }

    @Deprecated
    public void setMdId(String mdId) {
        this.mdId = mdId;
    }
}

