/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.objectStore;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MetadataObjectRecord;
import eu.dnetlib.rmi.data.ObjectStoreService;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.InputSource;

public class DownloadIntoObjectStoreJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(DownloadIntoObjectStoreJobNode.class);
    private String eprParam;
    private String objectStoreId;
    private String idXpath;
    private String contentDescription;
    private String objectIsInsideEpr;
    @Autowired
    private ResultSetFactory resultSetFactory;
    @Autowired
    private ResultSetClient resultSetClient;

    @Override
    protected String obtainServiceId(Env env) {
        return this.getServiceLocator().getServiceId(ObjectStoreService.class);
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getObjectStoreId() {
        return this.objectStoreId;
    }

    public void setObjectStoreId(String objectStoreId) {
        this.objectStoreId = objectStoreId;
    }

    @Override
    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        job.setAction("FEEDOBJECT");
        ResultSet rsIn = token.getEnv().getAttribute(this.getEprParam(), ResultSet.class);
        job.getParameters().put("obsID", this.getObjectStoreId());
        job.getParameters().put("mime", this.getContentDescription());
        Iterator client = this.resultSetClient.iter(rsIn, String.class).iterator();
        ResultSet rsOut = this.resultSetFactory.createResultSet(() -> new MetadataObjectIterator(client, "//*[local-name()='objIdentifier']", "xml"));
        token.setProgressProvider(new ResultsetProgressProvider(rsOut, this.resultSetClient));
        job.getParameters().put("epr", rsOut.toJson());
    }

    @Override
    protected BlackboardWorkflowJobListener generateBlackboardListener(Token token) {
        return new BlackboardWorkflowJobListener(token){

            @Override
            protected void responseToEnv(Env env, Map<String, String> responseParams) {
                log.info((Object)("Number of stored records: " + responseParams.get("total")));
                env.setAttribute("mainlog:total", responseParams.get("total"));
            }
        };
    }

    public String getObjectIsInsideEpr() {
        return this.objectIsInsideEpr;
    }

    public void setObjectIsInsideEpr(String objectIsInsideEpr) {
        this.objectIsInsideEpr = objectIsInsideEpr;
    }

    public String getIdXpath() {
        return this.idXpath;
    }

    public void setIdXpath(String idXpath) {
        this.idXpath = idXpath;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public void setContentDescription(String contentDescription) {
        this.contentDescription = contentDescription;
    }

    class MetadataObjectIterator
    implements Iterator<String> {
        private final Iterator<String> inputIterator;
        private String mime;

        public MetadataObjectIterator(Iterator<String> inputIterator, String xpath, String mime) {
            this.inputIterator = inputIterator;
        }

        @Override
        public boolean hasNext() {
            return this.inputIterator.hasNext();
        }

        @Override
        public String next() {
            try {
                String record = this.inputIterator.next();
                XPath xpath = XPathFactory.newInstance().newXPath();
                InputSource doc = new InputSource(new StringReader(record));
                String identifier = xpath.evaluate(DownloadIntoObjectStoreJobNode.this.getIdXpath(), doc);
                MetadataObjectRecord objectrecord = new MetadataObjectRecord(identifier, record, this.mime);
                return objectrecord.toJSON();
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public void remove() {
        }
    }
}

