/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.procs;

import eu.dnetlib.enabling.common.Stoppable;
import eu.dnetlib.enabling.common.StoppableDetails;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Graph;
import eu.dnetlib.msro.workflows.graph.GraphLoader;
import eu.dnetlib.msro.workflows.procs.ProcessEngine;
import eu.dnetlib.msro.workflows.procs.ProcessFactory;
import eu.dnetlib.msro.workflows.procs.ProcessRegistry;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.msro.workflows.util.ProcessCallback;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class WorkflowExecutor
implements Stoppable {
    private static final Log log = LogFactory.getLog(WorkflowExecutor.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private GraphLoader graphLoader;
    private ProcessRegistry processRegistry;
    private ProcessFactory processFactory;
    private ProcessEngine processEngine;
    private boolean paused = false;

    public void init() {
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            if (this.isPaused() || this.processRegistry.countRunningWfs() >= 100) {
                return;
            }
            WorkflowProcess process = this.processRegistry.nextProcessToStart();
            if (process != null) {
                this.processEngine.startProcess(process);
            } else {
                log.debug((Object)"WorkflowProcess queue is empty");
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public String startRepoHiWorkflow(String profileId, String dsId, String iface, ProcessCallback processCallback, String parent) throws Exception {
        if (this.isPaused()) {
            log.warn((Object)("Wf " + profileId + " not launched, because WorkflowExecutor is preparing for shutdown"));
            throw new MSROException("WorkflowExecutor is preparing for shutdown");
        }
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(profileId);
            Document doc = new SAXReader().read((Reader)new StringReader(profile));
            String name = doc.valueOf("//WORKFLOW_NAME");
            String family = doc.valueOf("//WORKFLOW_FAMILY");
            int priority = NumberUtils.toInt((String)"//WORKFLOW_PRIORITY", (int)50);
            boolean isReady = doc.valueOf("//CONFIGURATION/@status").equals(WorkflowsConstants.WorkflowStatus.EXECUTABLE.toString());
            boolean isDisabled = doc.valueOf("//CONFIGURATION/@start").equals("disabled");
            if (!isReady || isDisabled) {
                log.warn((Object)("Wf " + profileId + " not launched, because it is not ready to start or it is disabled"));
                throw new MSROException("Workflow " + profileId + " is not ready to start");
            }
            HashMap<String, String> globalParams = new HashMap<String, String>();
            for (Object o : doc.selectNodes("//CONFIGURATION/PARAMETERS/PARAM")) {
                Element p = (Element)o;
                globalParams.put(p.valueOf("@name"), p.getTextTrim());
            }
            Graph graph = this.graphLoader.loadGraph(doc, globalParams);
            WorkflowProcess process = this.processFactory.newProcess(name, family, dsId, iface, graph, priority, profileId, false, globalParams, processCallback, parent);
            return this.processRegistry.registerProcess(process, profileId);
        }
        catch (Exception e) {
            log.error((Object)("Error parsing workflow: " + profileId), (Throwable)e);
            throw new MSROException("Error parsing workflow");
        }
    }

    public String startWorkflow(String profileId, ProcessCallback processCallback, String parent) throws Exception {
        if (this.isPaused()) {
            log.warn((Object)("Wf " + profileId + " not launched, because WorkflowExecutor is preparing for shutdown"));
            throw new MSROException("WorkflowExecutor is preparing for shutdown");
        }
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(profileId);
            Document doc = new SAXReader().read((Reader)new StringReader(profile));
            String name = doc.valueOf("//WORKFLOW_NAME");
            String family = doc.valueOf("//WORKFLOW_FAMILY");
            int priority = NumberUtils.toInt((String)"//WORKFLOW_PRIORITY", (int)50);
            boolean isReady = doc.valueOf("//CONFIGURATION/@status").equals(WorkflowsConstants.WorkflowStatus.EXECUTABLE.toString());
            boolean isDisabled = doc.valueOf("//CONFIGURATION/@start").equals("disabled");
            String dsId = doc.valueOf("//DATASOURCE/@id");
            String iface = doc.valueOf("//DATASOURCE/@interface");
            if (!isReady || isDisabled) {
                log.warn((Object)("Wf " + profileId + " not launched, because it is not ready to start or it is disabled"));
                throw new MSROException("Workflow " + profileId + " is not ready to start");
            }
            HashMap<String, String> globalParams = new HashMap<String, String>();
            for (Object o : doc.selectNodes("//CONFIGURATION/PARAMETERS/PARAM")) {
                Element p = (Element)o;
                globalParams.put(p.valueOf("@name"), p.getTextTrim());
            }
            Graph graph = this.graphLoader.loadGraph(doc, globalParams);
            WorkflowProcess process = this.processFactory.newProcess(name, family, dsId, iface, graph, priority, profileId, false, globalParams, processCallback, parent);
            return this.processRegistry.registerProcess(process, profileId);
        }
        catch (Exception e) {
            log.error((Object)("Error parsing workflow: " + profileId), (Throwable)e);
            throw new MSROException("Error parsing workflow");
        }
    }

    public String startWorkflowTemplate(String profileId, String name, String family, int priority, String dsId, String iface, Map<String, String> params, ProcessCallback processCallback, String parent) throws Exception {
        if (this.isPaused()) {
            log.warn((Object)("Wf template " + profileId + " not launched, because WorkflowExecutor is preparing for shutdown"));
            throw new MSROException("WorkflowExecutor is preparing for shutdown");
        }
        try {
            String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(profileId);
            Document doc = new SAXReader().read((Reader)new StringReader(profile));
            HashMap<String, String> globalParams = new HashMap<String, String>();
            for (Object o : doc.selectNodes("//CONFIGURATION/PARAMETERS/PARAM")) {
                Element p = (Element)o;
                String pname = p.valueOf("@name");
                if (StringUtils.isNotBlank((CharSequence)params.get(pname))) {
                    globalParams.put(pname, params.get(pname));
                    continue;
                }
                if (p.selectSingleNode("@default") != null) {
                    globalParams.put(pname, p.valueOf("@default"));
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)p.valueOf("@required"), (CharSequence)"true")) {
                    globalParams.put(pname, "");
                    continue;
                }
                throw new MSROException("A required parameter is missing in wf template:" + pname);
            }
            Graph graph = this.graphLoader.loadGraph(doc, globalParams);
            WorkflowProcess process = this.processFactory.newProcess(name, family, dsId, iface, graph, priority, profileId, true, globalParams, processCallback, parent);
            return this.processRegistry.registerProcess(process, new String[0]);
        }
        catch (Exception e) {
            log.error((Object)("Error starting workflow template: " + profileId), (Throwable)e);
            throw new MSROException("Error starting workflow template", (Throwable)e);
        }
    }

    public void stop() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    public StoppableDetails getStopDetails() {
        int count = this.processRegistry.countRunningWfs();
        StoppableDetails.StopStatus status = this.isPaused() ? (count == 0 ? StoppableDetails.StopStatus.STOPPED : StoppableDetails.StopStatus.STOPPING) : StoppableDetails.StopStatus.RUNNING;
        return new StoppableDetails("D-NET workflow manager", "Running workflows: " + count, status);
    }

    public ProcessRegistry getProcessRegistry() {
        return this.processRegistry;
    }

    @Required
    public void setProcessRegistry(ProcessRegistry processRegistry) {
        this.processRegistry = processRegistry;
    }

    public GraphLoader getGraphLoader() {
        return this.graphLoader;
    }

    @Required
    public void setGraphLoader(GraphLoader graphLoader) {
        this.graphLoader = graphLoader;
    }

    public ProcessFactory getProcessFactory() {
        return this.processFactory;
    }

    @Required
    public void setProcessFactory(ProcessFactory processFactory) {
        this.processFactory = processFactory;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    @Required
    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }
}

