package eu.dnetlib.msro.workflows.nodes.index;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.provision.IndexService;

public class DeleteIndexJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(DeleteIndexJobNode.class);

	private String indexId;
	private String defaultIndexId;

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(IndexService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		log.info("deleting index id = " + getIndexId());

		job.setAction("DELETE");
		job.getParameters().put("id", getIndexId());
		job.getParameters().put("backend_Id", this.defaultIndexId);

	}

	public String getIndexId() {
		return this.indexId;
	}

	public void setIndexId(final String indexId) {
		this.indexId = indexId;
	}

	public String getDefaultIndexId() {
		return this.defaultIndexId;
	}

	public void setDefaultIndexId(final String defaultIndexId) {
		this.defaultIndexId = defaultIndexId;
	}
}
