package eu.dnetlib.msro.workflows.nodes.objectStore;

import java.util.Map;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.ObjectStoreService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateObjectStoreJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(CreateObjectStoreJobNode.class);

	private String interpretation;
	private String outputPrefix = "objectStore_";
	private boolean createOnlyIfMissing = false;

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(ObjectStoreService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) {
		log.info("preparing blackboard job for the creation of the objectStore ");
		final String basePath = token.getEnv().getAttribute("objectStoreBasePath", String.class);
		job.setAction("CREATE");
		job.getParameters().put("interpretation", this.interpretation);
		job.getParameters().put("createOnlyIfMissing", "" + createOnlyIfMissing);
		if (StringUtils.isNotBlank(basePath)) {
			job.getParameters().put("basePath", basePath);

		}
	}

	public String getInterpretation() {
		return this.interpretation;
	}

	public void setInterpretation(final String interpretation) {
		this.interpretation = interpretation;
	}

	public String getOutputPrefix() {
		return this.outputPrefix;
	}

	public void setOutputPrefix(final String outputPrefix) {
		this.outputPrefix = outputPrefix;
	}

	public boolean isCreateOnlyIfMissing() {
		return createOnlyIfMissing;
	}

	public void setCreateOnlyIfMissing(final boolean createOnlyIfMissing) {
		this.createOnlyIfMissing = createOnlyIfMissing;
	}

	@Override
	protected BlackboardWorkflowJobListener generateBlackboardListener(final Token token) {
		return new BlackboardWorkflowJobListener(token) {

			@Override
			protected void responseToEnv(final Env env, final Map<String, String> responseParams) {

				env.setAttribute(getOutputPrefix() + "interpretation", CreateObjectStoreJobNode.this.interpretation);
				env.setAttribute(getOutputPrefix() + "id", responseParams.get("objectStoreId"));
			}
		};
	}

}
