package eu.dnetlib.msro.workflows.nodes.objectStore;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.ObjectStoreService;

public class DeleteObjectStoreJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(DeleteObjectStoreJobNode.class);

	private String objectstoreId;

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(ObjectStoreService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		log.info("preparing blackboard job: delete of mdstore " + getObjectstoreId());
		job.setAction("DELETE");
		job.getParameters().put("obsID", getObjectstoreId());
	}

	/**
	 * @return the objectstoreId
	 */
	public String getObjectstoreId() {
		return this.objectstoreId;
	}

	/**
	 * @param objectstoreId
	 *            the objectstoreId to set
	 */
	public void setObjectstoreId(final String objectstoreId) {
		this.objectstoreId = objectstoreId;
	}

}
