/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.info;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.datasource.DatasourceManagerService;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoveApiExtraFieldsJobNode
extends SimpleJobNode {
    private String datasourceId;
    private String datasourceInterface;
    private List<String> fields;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    @Override
    protected String execute(Env env) throws Exception {
        if (this.fields != null) {
            Set<String> invalidFields = this.fields.stream().map(String::toLowerCase).collect(Collectors.toSet());
            Map<String, String> map = this.calculateValidExtraFields(this.datasourceId, this.datasourceInterface, invalidFields);
            ((DatasourceManagerService)this.serviceLocator.getService(DatasourceManagerService.class)).bulkUpdateApiExtraFields(this.datasourceId, this.datasourceInterface, map);
        }
        return Arc.DEFAULT_ARC;
    }

    private Map<String, String> calculateValidExtraFields(String repoId, String ifaceId, Set<String> invalidFields) throws Exception {
        HashMap<String, String> res = new HashMap<String, String>();
        SAXReader reader = new SAXReader();
        String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(repoId);
        Document doc = reader.read((Reader)new StringReader(profile));
        Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']");
        if (ifcNode != null) {
            for (Object o : ifcNode.selectNodes("./INTERFACE_EXTRA_FIELD")) {
                String name = ((Node)o).valueOf("@name");
                if (invalidFields.contains(name.toLowerCase())) continue;
                res.put(name, ((Node)o).getText());
            }
        }
        return res;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }
}

