/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.transform;

import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ApplyXsltJobNode
extends SimpleJobNode {
    private String inputEprParam;
    private String outputEprParam;
    private String xsltClasspath;
    private Map<String, String> xsltParams;
    @Autowired
    private ResultSetFactory resultSetFactory;

    @Override
    protected String execute(Env env) throws Exception {
        ResultSet rsIn = env.getAttribute(this.inputEprParam, ResultSet.class);
        if (rsIn == null) {
            throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.xsltParams != null) {
            params.putAll(this.xsltParams);
        }
        for (Map.Entry<String, Object> e : env.getAttributes().entrySet()) {
            params.put(e.getKey().replaceAll(":", "_"), e.getValue().toString());
        }
        ClassPathResource xslt = new ClassPathResource(this.xsltClasspath);
        ResultSet rsOut = this.resultSetFactory.xsltMap(rsIn, (Resource)xslt, params);
        env.setAttribute(this.outputEprParam, rsOut);
        return Arc.DEFAULT_ARC;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getXsltClasspath() {
        return this.xsltClasspath;
    }

    public void setXsltClasspath(String xsltClasspath) {
        this.xsltClasspath = xsltClasspath;
    }

    public Map<String, String> getXsltParams() {
        return this.xsltParams;
    }

    public void setXsltParams(Map<String, String> xsltParams) {
        this.xsltParams = xsltParams;
    }
}

