package eu.dnetlib.msro.workflows.nodes.download;

import java.util.Map;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.ObjectStoreService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;


// TODO: Auto-generated Javadoc

/**
 * The Class DownloadFromMetadata is a job node that send a blackboard message to the Download service to start to download file from url
 * retrieved by Metadata .
 */
public class DownloadFromMetadataJobNode extends BlackboardJobNode {

	protected String regularExpression;
	/**
	 * The inputepr param.
	 */
	private String inputeprParam;
	/**
	 * The object store id.
	 */
	private String objectStoreID;
	/**
	 * The plugin.
	 */
	private String plugin;
	/**
	 * The protocol.
	 */
	private String protocol;
	/**
	 * The mime type.
	 */
	private String mimeType;

	@Autowired
	private ResultSetClient resultSetClient;

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(ObjectStoreService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		job.setAction("DOWNLOAD");
		final ResultSet<?> rs = token.getEnv().getAttribute(getInputeprParam(), ResultSet.class);
		token.setProgressProvider(new ResultsetProgressProvider(rs, this.resultSetClient));
		job.getParameters().put("epr", rs.toJson());
		job.getParameters().put("protocol", getProtocol());
		job.getParameters().put("plugin", getPlugin());
		job.getParameters().put("mimeType", getMimeType());
		job.getParameters().put("objectStoreID", getObjectStoreID());

		if (!StringUtils.isEmpty(getRegularExpression())) {
			job.getParameters().put("regularExpressions", getRegularExpression());
		}

	}

	@Override
	protected BlackboardWorkflowJobListener generateBlackboardListener(final Token token) {
		return new BlackboardWorkflowJobListener(token) {

			@Override
			protected void responseToEnv(final Env env, final Map<String, String> responseParams) {
				env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "total", responseParams.get("total"));
			}
		};
	}

	/**
	 * Gets the inputepr param.
	 *
	 * @return the inputeprParam
	 */
	public String getInputeprParam() {
		return this.inputeprParam;
	}

	/**
	 * Sets the inputepr param.
	 *
	 * @param inputeprParam
	 *            the inputeprParam to set
	 */
	public void setInputeprParam(final String inputeprParam) {
		this.inputeprParam = inputeprParam;
	}

	/**
	 * Gets the object store id.
	 *
	 * @return the objectStoreID
	 */
	public String getObjectStoreID() {
		return this.objectStoreID;
	}

	/**
	 * Sets the object store id.
	 *
	 * @param objectStoreID
	 *            the objectStoreID to set
	 */
	public void setObjectStoreID(final String objectStoreID) {
		this.objectStoreID = objectStoreID;
	}

	/**
	 * Gets the plugin.
	 *
	 * @return the plugin
	 */
	public String getPlugin() {
		return this.plugin;
	}

	/**
	 * Sets the plugin.
	 *
	 * @param plugin
	 *            the plugin to set
	 */
	public void setPlugin(final String plugin) {
		this.plugin = plugin;
	}

	/**
	 * Gets the protocol.
	 *
	 * @return the protol
	 */
	public String getProtocol() {
		return this.protocol;
	}

	/**
	 * Sets the protocol.
	 *
	 * @param protol
	 *            the protol to set
	 */
	public void setProtocol(final String protol) {
		this.protocol = protol;
	}

	/**
	 * Gets the mime type.
	 *
	 * @return the mimeType
	 */
	public String getMimeType() {
		return this.mimeType;
	}

	/**
	 * Sets the mime type.
	 *
	 * @param mimeType
	 *            the mimeType to set
	 */
	public void setMimeType(final String mimeType) {
		this.mimeType = mimeType;
	}

	public String getRegularExpression() {
		return this.regularExpression;
	}

	public void setRegularExpression(final String regularExpression) {
		this.regularExpression = regularExpression;
	}

}
