package eu.dnetlib.msro.workflows.nodes.repohi;

import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdateWfParametersJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(UpdateWfParametersJobNode.class);
	private Map<String, String> envParams;
	private Map<String, String> simpleParams;
	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {

		final Map<String, String> params = new HashMap<String, String>();

		if (this.simpleParams != null) {
			for (final Map.Entry<String, String> e : this.simpleParams.entrySet()) {
				params.put(e.getKey(), e.getValue());
			}
		}
		if (this.envParams != null) {
			for (final Map.Entry<String, String> e : this.envParams.entrySet()) {
				params.put(e.getKey(), env.getAttribute(e.getValue(), String.class));
			}
		}

		if (!params.isEmpty()) {
			final String profId = env.getAttribute("repoWfId", String.class);
			final String profile = this.serviceLocator.getService(ISLookUpService.class).getResourceProfile(profId);
			final Document doc = new SAXReader().read(new StringReader(profile));
			final Node paramsNode = doc.selectSingleNode("//CONFIGURATION/PARAMETERS");
			for (final Map.Entry<String, String> e : params.entrySet()) {
				final Element node = (Element) paramsNode.selectSingleNode("./PARAM[@name = '" + StringEscapeUtils.escapeXml11(e.getKey()) + "']");
				if (node != null) {
					node.setText("" + e.getValue());
					log.debug(String.format("Workflow %s, param %s = %s", profId, e.getKey(), "" + e.getValue()));
				} else {
					log.error(String.format("Invalid param %s for %s", e.getKey(), profId));
					throw new MSROException(String.format("Invalid param %s for %s", e.getKey(), profId));
				}
			}

			final List<Node> emptySysParams = paramsNode.selectNodes("//PARAM[@managedBy='system' and @required='true' and not(text())]");
			if (emptySysParams.size() > 0) {
				((Element) doc.selectSingleNode("//CONFIGURATION")).addAttribute("status", WorkflowsConstants.WorkflowStatus.WAIT_SYS_SETTINGS.toString());
				throw new MSROException("Error: the following system parameters are empty: "+ Joiner.on(",").join(Iterables.transform(emptySysParams, p -> p.asXML())));
			} else if (paramsNode.selectNodes("//PARAM[@managedBy='user' and @required='true' and not(text())]").size() > 0) {
				((Element) doc.selectSingleNode("//CONFIGURATION")).addAttribute("status", WorkflowsConstants.WorkflowStatus.WAIT_USER_SETTINGS.toString());
			} else {
				((Element) doc.selectSingleNode("//CONFIGURATION")).addAttribute("status", WorkflowsConstants.WorkflowStatus.EXECUTABLE.toString());
			}

			this.serviceLocator.getService(ISRegistryService.class).updateProfile(profId, doc.asXML(), doc.valueOf("//RESOURCE_TYPE/@value"));
		}

		return Arc.DEFAULT_ARC;
	}

	public Map<String, String> getEnvParams() {
		return this.envParams;
	}

	public void setEnvParams(final Map<String, String> envParams) {
		this.envParams = envParams;
	}

	public Map<String, String> getSimpleParams() {
		return this.simpleParams;
	}

	public void setSimpleParams(final Map<String, String> simpleParams) {
		this.simpleParams = simpleParams;
	}

}
