package eu.dnetlib.msro.workflows.nodes.xmlvalidation;

import java.util.Map;

import com.google.common.collect.Maps;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 * Created by alessia on 16/03/17.
 */
public class XMLErrorHandler implements ErrorHandler {

	private static final Log log = LogFactory.getLog(XMLErrorHandler.class);

	private Map<String, String> report = Maps.newHashMap();
	private String xmlID;
	private boolean valid = true;

	public void warning(SAXParseException e) throws SAXException {
		log.warn(e.getMessage());
		this.report.put(xmlID, "[W] "+e.getMessage());
		valid = false;
	}

	public void error(SAXParseException e) throws SAXException {
		log.error(e.getMessage());
		this.report.put(xmlID, "[E] "+e.getMessage());
		valid = false;
	}

	public void fatalError(SAXParseException e) throws SAXException {
		log.fatal(e.getMessage());
		this.report.put(xmlID, "[FE] "+e.getMessage());
		valid = false;
	}

	public Map<String, String> getReport() {
		return report;
	}

	public void setReport(final Map<String, String> report) {
		this.report = report;
	}

	public String getXmlID() {
		return xmlID;
	}

	public void setXmlID(final String xmlID) {
		this.xmlID = xmlID;
	}

	public boolean isValid() {
		return valid;
	}

	public void setValid(final boolean valid) {
		this.valid = valid;
	}
}
