/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.procs;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Graph;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.msro.workflows.util.ProcessCallback;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ProcessFactory {
    private static final Log log = LogFactory.getLog(ProcessFactory.class);
    private String oldGeneratedId = "";
    @Autowired
    private UniqueServiceLocator serviceLocator;

    public WorkflowProcess newProcess(String name, String family, String dsId, String dsInterface, Graph graph, int priority, String profileId, boolean template, Map<String, String> globalParams, ProcessCallback processCallback, String parent) throws MSROException {
        String dsName = this.findDsName(dsId);
        return new WorkflowProcess(this.generateProcessId(), name, family, dsId, dsName, dsInterface, graph, priority, profileId, template, globalParams, processCallback, parent);
    }

    private String findDsName(String dsId) throws MSROException {
        if (StringUtils.isBlank((CharSequence)dsId)) {
            return null;
        }
        String query = "collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "' or .//DATASOURCE_ORIGINAL_ID='" + dsId + "']//OFFICIAL_NAME/text()";
        try {
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query);
        }
        catch (Exception e) {
            log.error((Object)("Error executing xquery: " + query));
            throw new MSROException("Error executing xquery: " + query, (Throwable)e);
        }
    }

    private synchronized String generateProcessId() {
        String id = "";
        do {
            id = "wf_" + new SimpleDateFormat("yyyyMMdd_HHmmss_S").format(new Date());
            log.info((Object)("Generated processID " + id));
        } while (id.equals(this.oldGeneratedId));
        this.oldGeneratedId = id;
        return id;
    }
}

