package eu.dnetlib.msro.workflows.nodes.misc;

import com.google.common.base.Splitter;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.rmi.datasource.DatasourceConstants;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import org.springframework.beans.factory.annotation.Autowired;

public class VerifyDatasourceJobNode extends SimpleJobNode implements ProcessAware {

	@Autowired
	private UniqueServiceLocator serviceLocator;

	private String expectedInterfaceTypologyPrefixes;

	private String expectedCompliancePrefixes;

	private WorkflowProcess process;

	@Override
	protected String execute(final Env env) throws Exception {
		final String dsId = this.process.getDsId();
		final String ifaceId = this.process.getDsInterface();
		final ISLookUpService lookupService = this.serviceLocator.getService(ISLookUpService.class);

		String compliance;
		try {
			compliance = lookupService.getResourceProfileByQuery("/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//INTERFACE[@id = '" + ifaceId
					+ "']/INTERFACE_EXTRA_FIELD[@name='"
					+ DatasourceConstants.OVERRIDING_COMPLIANCE_FIELD + "']/text()");
		} catch (final ISLookUpDocumentNotFoundException e) {
			compliance = lookupService.getResourceProfileByQuery("/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//INTERFACE[@id = '" + ifaceId
					+ "']/@compliance/string()");
		}

		final String typology = lookupService.getResourceProfileByQuery("/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//INTERFACE[@id = '" + ifaceId
				+ "']/@typology/string()");

		verifyValue(compliance, this.expectedCompliancePrefixes);
		verifyValue(typology, this.expectedInterfaceTypologyPrefixes);

		if (isPending(dsId)) {
			return "validateDs";
		} else {
			return Arc.DEFAULT_ARC;
		}
	}

	private void verifyValue(final String value, final String expected) throws Exception {
		if (expected != null && !expected.isEmpty()) {
			for (final String s : Splitter.on(",").omitEmptyStrings().trimResults().split(expected)) {
				if (value.toLowerCase().startsWith(s.toLowerCase())) { return; }
			}
			throw new MSROException("Invalid value: " + value + ", Valid term prefixes are: [" + expected + "]");
		}
	}

	private boolean isPending(final String id) throws ISLookUpDocumentNotFoundException, ISLookUpException {
		final String query = "/*[.//RESOURCE_IDENTIFIER/@value='" + id + "']//RESOURCE_KIND/@value/string()";
		final String res = this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(query);
		return res.trim().equals("PendingRepositoryResources");
	}

	public String getExpectedInterfaceTypologyPrefixes() {
		return this.expectedInterfaceTypologyPrefixes;
	}

	public void setExpectedInterfaceTypologyPrefixes(final String expectedInterfaceTypologyPrefixes) {
		this.expectedInterfaceTypologyPrefixes = expectedInterfaceTypologyPrefixes;
	}

	public String getExpectedCompliancePrefixes() {
		return this.expectedCompliancePrefixes;
	}

	public void setExpectedCompliancePrefixes(final String expectedCompliancePrefixes) {
		this.expectedCompliancePrefixes = expectedCompliancePrefixes;
	}

	public WorkflowProcess getProcess() {
		return this.process;
	}

	@Override
	public void setProcess(final WorkflowProcess process) {
		this.process = process;
	}

}
