package eu.dnetlib.msro.workflows.nodes.transform;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class MdBuilderJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(MdBuilderJobNode.class);

	private Resource mdBuilderTemplateXslt;

	private String inputEprParam;
	private String outputEprParam;
	private String datasourceId;
	private String datasourceInterface;
	private String datasourceName;

	@Autowired
	private ResultSetFactory resultSetFactory;

	@javax.annotation.Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws MSROException {
		final ResultSet<?> rsIn = env.getAttribute(this.inputEprParam, ResultSet.class);

		if (rsIn == null) { throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV"); }
		StringTemplate st = null;
		try {
			st = new StringTemplate(IOUtils.toString(getMdBuilderTemplateXslt().getInputStream(), Charset.forName("UTF-8")));
			st.setAttribute("datasourceId", this.datasourceId);
			st.setAttribute("datasourceName", this.datasourceName);
			st.setAttribute("datasourceApi", this.datasourceInterface);
			st.setAttribute("xpath", getMetadataIdentifierPath().replace("\"", "'"));
			st.setAttribute("baseurl", URLEncoder.encode(getBaseUrl(), "UTF-8"));
			st.setAttribute("metadatanamespace", getMetadataNamespace());
			List<String> namespacePrefix;
			String xQuery = "/*[.//RESOURCE_IDENTIFIER/@value='" + this.datasourceId + "']//EXTRA_FIELDS/FIELD/value[../key='NamespacePrefix']/string()";
			namespacePrefix = this.serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xQuery);
			if (namespacePrefix != null && namespacePrefix.size() != 0) {
				st.setAttribute("namespacePrefix", namespacePrefix.get(0));
			}
			final ResultSet<String> rsOut = this.resultSetFactory.xsltMap(rsIn, st.toString());

			env.setAttribute(this.outputEprParam, rsOut);

			if (datasourceInterface != null) {
				env.setAttribute(WorkflowsConstants.LOG_DATASOURCE_INTERFACE, this.datasourceInterface);
			}

			return Arc.DEFAULT_ARC;
		} catch (final ISLookUpException e) {
			throw new MSROException("Error while initializing mdBuilder template (" + getMdBuilderTemplateXslt().getFilename() + ") for datasource "
					+ this.datasourceId, e);
		} catch (final IOException e) {
			throw new MSROException("Error parsing template: " + getMdBuilderTemplateXslt().getFilename(), e);
		} catch (final Exception e) {
			log.error(st.toString());
			throw new MSROException(e);
		}
	}

	private String getBaseUrl() throws ISLookUpException {
		String xQuery = "/*[.//RESOURCE_IDENTIFIER/@value='{datasourceId}']//INTERFACE[@id='{interfaceId}']//BASE_URL/string()";
		xQuery = xQuery.replace("{interfaceId}", this.datasourceInterface).replace("{datasourceId}", this.datasourceId);
		return this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xQuery);
	}

	private String getMetadataIdentifierPath() throws ISLookUpException {
		String xQuery = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') "
				+ "return $x//INTERFACE[@id='{interfaceId}']/INTERFACE_EXTRA_FIELD[@name='metadata_identifier_path']/string()";
		xQuery = xQuery.replace("{interfaceId}", this.datasourceInterface);
		return this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xQuery);
	}

	private String getMetadataNamespace() {
		try {
			String xQuery = "let $x := /*[.//RESOURCE_IDENTIFIER/@value='{datasourceId}']//INTERFACE[@id='{interfaceId}']/ACCESS_PROTOCOL/@format/string() "
					+ "return /*[.//RESOURCE_TYPE/@value='MetadataFormatDSResourceType']//METADATAFORMAT[@Prefix=$x]/@NameSpace/string()";
			xQuery = xQuery.replace("{interfaceId}", this.datasourceInterface).replace("{datasourceId}", this.datasourceId);
			return this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(xQuery);
		} catch (final ISLookUpException e) {
			log.error("The interface is not OAI or the format is not found in the MetadataFormatDSResourceType, thus metadata format in the <about> section "
					+ "cannot be managed here and it will be left incomplete (for the time being)");
			return "";
		}
	}

	public String getInputEprParam() {
		return this.inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return this.outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public String getDatasourceId() {
		return this.datasourceId;
	}

	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getDatasourceInterface() {
		return this.datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}

	public String getDatasourceName() {
		return datasourceName;
	}

	public void setDatasourceName(final String datasourceName) {
		this.datasourceName = datasourceName;
	}

	public Resource getMdBuilderTemplateXslt() {
		return this.mdBuilderTemplateXslt;
	}

	@Required
	public void setMdBuilderTemplateXslt(final Resource mdBuilderTemplateXslt) {
		this.mdBuilderTemplateXslt = mdBuilderTemplateXslt;
	}

}
