package eu.dnetlib.msro.workflows.util;

import eu.dnetlib.enabling.resultset.ResultSetInfo;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.rmi.common.ResultSet;

public class ResultsetProgressProvider implements ProgressProvider {

	private final ResultSet<?> rs;
	private final ResultSetClient rsClient;

	public ResultsetProgressProvider(final ResultSet<?> rs, final ResultSetClient rsClient) {
		super();
		this.rs = rs;
		this.rsClient = rsClient;
	}

	@Override
	public String getProgressDescription() {
		try {
			final ResultSetInfo info = this.rsClient.info(this.rs);

			if (info == null) { return "-"; }

			return info.getCursor() < 0 ? "-"
					: String.format("%s / %s", info.getCursor(), info.isInaccurate() || info.getTotal() < 0 ? "???" : info.getTotal());

		} catch (final Throwable e) {
			return "-";
		}
	}

}
