/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.xmlvalidation;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLErrorHandler
implements ErrorHandler {
    private static final Log log = LogFactory.getLog(XMLErrorHandler.class);
    private Map<String, String> report = Maps.newHashMap();
    private String xmlID;
    private boolean valid = true;

    @Override
    public void warning(SAXParseException e) throws SAXException {
        log.warn((Object)e.getMessage());
        this.report.put(this.xmlID, "[W] " + e.getMessage());
        this.valid = false;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        log.error((Object)e.getMessage());
        this.report.put(this.xmlID, "[E] " + e.getMessage());
        this.valid = false;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        log.fatal((Object)e.getMessage());
        this.report.put(this.xmlID, "[FE] " + e.getMessage());
        this.valid = false;
    }

    public Map<String, String> getReport() {
        return this.report;
    }

    public void setReport(Map<String, String> report) {
        this.report = report;
    }

    public String getXmlID() {
        return this.xmlID;
    }

    public void setXmlID(String xmlID) {
        this.xmlID = xmlID;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }
}

