/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.xmlvalidation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.miscutils.functional.xml.SaxonHelper;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.nodes.xmlvalidation.XMLErrorHandler;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.SchemaFactory;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLSchemaValidatorJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(XMLSchemaValidatorJobNode.class);
    @Autowired
    private ResultSetClient resultSetClient;
    @Autowired
    private ResultSetFactory resultSetFactory;
    @Autowired
    private SaxonHelper saxonHelper;
    private String eprParam;
    private String validEprParam;
    private boolean enableValidation;
    private boolean useDeclaredSchemaUrl;
    private String xmlSchemaURL;
    private Map<String, String> report = Maps.newHashMap();
    private Map<String, String> namespaces = Maps.newHashMap();
    private XPathSelector originalIdSelector;
    private XPathSelector metadataSelector;
    private XMLErrorHandler errorHandler = new XMLErrorHandler();

    @Override
    protected String execute(Env env) throws Exception {
        ResultSet rsIn = env.getAttribute(this.eprParam, ResultSet.class);
        if (rsIn == null) {
            throw new MSROException("InputEprParam (" + this.eprParam + ") not found in ENV");
        }
        if (!this.enableValidation) {
            env.setAttribute(this.validEprParam, rsIn);
            return Arc.DEFAULT_ARC;
        }
        XMLReader reader = this.prepareReader();
        Iterable records = this.resultSetClient.iter(rsIn, String.class);
        this.addNamespaces();
        this.originalIdSelector = this.saxonHelper.help().prepareXPathSelector("//dri:recordIdentifier/text()", this.namespaces);
        this.metadataSelector = this.saxonHelper.help().prepareXPathSelector("//oai:metadata/*", this.namespaces);
        ResultSet rsOut = this.resultSetFactory.createResultSet(Iterables.filter((Iterable)records, s -> {
            try {
                XdmItem metadataItem = this.saxonHelper.help().evaluateSingle(s, this.metadataSelector);
                return this.validate(this.saxonHelper.help().setSerializerProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes").evaluateSingleAsString(s, this.originalIdSelector), metadataItem.toString(), reader);
            }
            catch (SaxonApiException e) {
                throw new RuntimeException(e);
            }
        }));
        env.setAttribute(this.validEprParam, rsOut);
        env.setAttribute("validationReport", this.errorHandler.getReport());
        return Arc.DEFAULT_ARC;
    }

    private void addNamespaces() {
        this.namespaces.put("dri", "http://www.driver-repository.eu/namespace/dri");
        this.namespaces.put("oai", "http://www.openarchives.org/OAI/2.0/");
    }

    private XMLReader prepareReader() throws ParserConfigurationException, SAXException, MSROException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        if (!this.useDeclaredSchemaUrl) {
            if (StringUtils.isBlank((CharSequence)this.xmlSchemaURL)) {
                throw new MSROException("Cannot create XMLReader for blank xml schema");
            }
            try {
                URL url = new URL(this.xmlSchemaURL);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                factory.setSchema(schemaFactory.newSchema(url));
            }
            catch (MalformedURLException e) {
                throw new MSROException("XML schema url " + this.xmlSchemaURL + " is malformed", (Throwable)e);
            }
        }
        XMLReader reader = parser.getXMLReader();
        reader.setErrorHandler(this.errorHandler);
        return reader;
    }

    private boolean validate(String id, String record, XMLReader reader) {
        InputSource inputSource = new InputSource(new StringReader(record));
        try {
            XMLErrorHandler err = (XMLErrorHandler)reader.getErrorHandler();
            err.setValid(true);
            err.setXmlID(id);
            reader.parse(inputSource);
            return err.isValid();
        }
        catch (IOException | SAXException e) {
            log.error((Object)("The record could not be validated because of " + e.getMessage()));
            return false;
        }
    }

    public ResultSetClient getResultSetClient() {
        return this.resultSetClient;
    }

    public void setResultSetClient(ResultSetClient resultSetClient) {
        this.resultSetClient = resultSetClient;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public boolean isEnableValidation() {
        return this.enableValidation;
    }

    public void setEnableValidation(boolean enableValidation) {
        this.enableValidation = enableValidation;
    }

    public boolean isUseDeclaredSchemaUrl() {
        return this.useDeclaredSchemaUrl;
    }

    public void setUseDeclaredSchemaUrl(boolean useDeclaredSchemaUrl) {
        this.useDeclaredSchemaUrl = useDeclaredSchemaUrl;
    }

    public String getXmlSchemaURL() {
        return this.xmlSchemaURL;
    }

    public void setXmlSchemaURL(String xmlSchemaURL) {
        this.xmlSchemaURL = xmlSchemaURL;
    }

    public ResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }

    public String getValidEprParam() {
        return this.validEprParam;
    }

    public void setValidEprParam(String validEprParam) {
        this.validEprParam = validEprParam;
    }

    public Map<String, String> getReport() {
        return this.report;
    }

    public void setReport(Map<String, String> report) {
        this.report = report;
    }
}

