package eu.dnetlib.msro.workflows.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by michele on 19/11/15.
 */
public class Graph {

	private final Map<String, GraphNode> nodes = new HashMap<String, GraphNode>();
	private List<Arc> arcs = new ArrayList<Arc>();

	public void addArc(final Arc arc) {
		this.arcs.add(arc);
	}

	public void addNode(final GraphNode node) {
		this.nodes.put(node.getName(), node);
	}

	public Set<String> nodeNames() {
		return this.nodes.keySet();
	}

	public Collection<GraphNode> nodes() {
		return this.nodes.values();
	}

	public GraphNode getNode(final String name) {
		return this.nodes.get(name);
	}

	public List<Arc> getArcs() {
		return this.arcs;
	}

	public void setArcs(final List<Arc> arcs) {
		this.arcs = arcs;
	}

	public Set<GraphNode> startNodes() {
		final Set<GraphNode> res = new HashSet<GraphNode>();
		for (final GraphNode n : this.nodes.values()) {
			if (n.isStart()) {
				res.add(n);
			}
		}
		return res;
	}

	public Set<GraphNode> nextNodes(final GraphNode current, final String arcName) {
		final Set<GraphNode> res = new HashSet<GraphNode>();
		for (final Arc arc : this.arcs) {
			if (StringUtils.equals(arc.getFrom(), current.getName()) && StringUtils.equals(arc.getName(), arcName)) {
				res.add(this.nodes.get(arc.getTo()));
			}
		}
		return res;
	}

	public int getNumberOfIncomingArcs(final GraphNode node) {
		int count = 0;
		for (final Arc arc : this.arcs) {
			if (arc.getTo().equals(node.getName())) {
				count++;
			}
		}
		return count;
	}

	@Override
	public String toString() {
		return "\n************************\nNodes: " + this.nodes + "\nArcs:  " + this.arcs + "\n************************\n";
	}
}
