package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardClientHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobImpl;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJobRegistry;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BlackboardJobNode extends ProcessNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(BlackboardJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM
	@Autowired
	private UniqueServiceLocator serviceLocator;
	/**
	 * blackboard handler.
	 */
	@Autowired
	private BlackboardClientHandler blackboardClientHandler;

	/**
	 * blackboard job registry.
	 */
	@Autowired
	private BlackboardJobRegistry jobRegistry;

	@Override
	public final void execute(final Token token) {
		log.info("executing blackboard node");

		try {
			token.getEnv().setAttribute(WorkflowsConstants.BLACKBOARD_IS_BLACKBOARD, true);

			final String serviceId = obtainServiceId(token.getEnv());
			if (StringUtils.isBlank(serviceId)) {
				final String msg = "cannot locate target service profile: " + serviceId;
				log.error(msg);
				token.releaseAsFailed(msg);
				token.release();
				return;
			}

			final BlackboardJob job = this.blackboardClientHandler.newJob(serviceId);

			token.getEnv().setAttribute(WorkflowsConstants.BLACKBOARD_JOB, job);
			token.getEnv().setAttribute(WorkflowsConstants.BLACKBOARD_SERVICE_ID, ((BlackboardJobImpl) job).getServiceId());
			prepareJob(job, token);

			this.jobRegistry.registerJobListener(job, generateBlackboardListener(token));

			this.blackboardClientHandler.assign(job);

		} catch (final Throwable e) {
			log.error("cannot prepare blackboard job", e);
			token.releaseAsFailed(e);
		}
	}

	abstract protected String obtainServiceId(final Env env);

	abstract protected void prepareJob(final BlackboardJob job, final Token token) throws Exception;

	protected BlackboardWorkflowJobListener generateBlackboardListener(final Token token) {
		return new BlackboardWorkflowJobListener(token);
	}

	public UniqueServiceLocator getServiceLocator() {
		return this.serviceLocator;
	}

}
