package eu.dnetlib.msro.workflows.nodes.blackboard;

import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.blackboard.AbstractBlackboardJobListener;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class BlackboardWorkflowJobListener extends AbstractBlackboardJobListener {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(BlackboardWorkflowJobListener.class);

	/**
	 * workflow node token.
	 */
	private Token token;

	public BlackboardWorkflowJobListener(final Token token) {
		super();
		this.token = token;
	}

	@Override
	protected void onDone(final BlackboardJob job) {
		log.debug("Blackboard workflow node DONE");
		responseToEnv(this.token.getEnv(), job.getParameters());
		this.token.setNextArc(Arc.DEFAULT_ARC);
		this.token.release();
	}

	@Override
	final public void processJob(final BlackboardJob job) {
		this.token.getEnv().setAttribute(WorkflowsConstants.BLACKBOARD_JOB, job);
		super.processJob(job);
	}

	@Override
	final protected void onFailed(final BlackboardJob job) {
		log.warn("Blackboard workflow node FAILED: " + job.getError());
		responseToEnv(this.token.getEnv(), job.getParameters());
		this.token.releaseAsFailed(job.getError());
	}

	protected void responseToEnv(final Env env, final Map<String, String> responseParams) {
		for (final Entry<String, String> entry : responseParams.entrySet()) {
			env.setAttribute(WorkflowsConstants.BLACKBOARD_PARAM_PREFIX + entry.getKey(), entry.getValue());
		}
	}

	@Override
	protected void onOngoing(final BlackboardJob job) {
		log.debug("Blackboard workflow node ONGOING");
		this.token.getEnv().setAttribute(WorkflowsConstants.BLACKBOARD_IS_GOING, true);
	}

	public Token getToken() {
		return this.token;
	}

	public void setToken(final Token token) {
		this.token = token;
	}

}
