/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.procs;

import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.graph.Graph;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ProcessCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.math.NumberUtils;

public class WorkflowProcess
implements Comparable<WorkflowProcess> {
    private final String id;
    private final String name;
    private final String family;
    private String dsId;
    private String dsName;
    private String dsInterface;
    private final Graph graph;
    private final ProcessCallback callback;
    private final int priority;
    private final Env env;
    private final List<Token> tokens = new CopyOnWriteArrayList<Token>();
    private long lastActivityDate;
    private Status status;
    private long startDate = 0L;
    private long endDate = 0L;
    private final String profileId;
    private final boolean template;
    private Map<String, List<Token>> pausedJoinNodeTokens = new HashMap<String, List<Token>>();
    private Map<String, String> globalParams;
    private String error;
    private String errorStacktrace;
    private Map<String, String> outputParams = new HashMap<String, String>();
    private String parentProfileId;

    public WorkflowProcess(String id, String name, String family, String dsId, String dsName, String dsInterface, Graph graph, int priority, String profileId, boolean template, Map<String, String> globalParams, ProcessCallback callback, String parentProfileId) {
        this.id = id;
        this.name = name;
        this.family = family;
        this.dsId = dsId;
        this.dsName = dsName;
        this.dsInterface = dsInterface;
        this.graph = graph;
        this.priority = priority;
        this.callback = callback;
        this.status = Status.CREATED;
        this.env = new Env();
        this.profileId = profileId;
        this.template = template;
        this.globalParams = globalParams;
        this.lastActivityDate = DateUtils.now();
        this.parentProfileId = parentProfileId;
    }

    public void setParentProfileId(String parentProfileId) {
        this.parentProfileId = parentProfileId;
    }

    public String getDsId() {
        return this.dsId;
    }

    public void setDsId(String dsId) {
        this.dsId = dsId;
    }

    public String getDsName() {
        return this.dsName;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public String getDsInterface() {
        return this.dsInterface;
    }

    public void setDsInterface(String dsInterface) {
        this.dsInterface = dsInterface;
    }

    public Map<String, List<Token>> getPausedJoinNodeTokens() {
        return this.pausedJoinNodeTokens;
    }

    public void setPausedJoinNodeTokens(Map<String, List<Token>> pausedJoinNodeTokens) {
        this.pausedJoinNodeTokens = pausedJoinNodeTokens;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Env getEnv() {
        return this.env;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public void kill() {
        this.setStatus(Status.KILLED);
    }

    public ProcessCallback getCallback() {
        return this.callback;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isTerminated() {
        switch (this.status) {
            case SUCCESS: 
            case FAILURE: 
            case KILLED: {
                return true;
            }
        }
        return false;
    }

    public long getLastActivityDate() {
        return this.lastActivityDate;
    }

    public void setLastActivityDate(long lastActivityDate) {
        this.lastActivityDate = lastActivityDate;
    }

    public String toString() {
        return String.format("[process id='%s' name='%s']", this.id, this.name);
    }

    @Override
    public int compareTo(WorkflowProcess wp) {
        return NumberUtils.compare((int)this.getPriority(), (int)wp.getPriority());
    }

    public Map<String, String> getGlobalParams() {
        return this.globalParams;
    }

    public void setGlobalParams(Map<String, String> globalParams) {
        this.globalParams = globalParams;
    }

    public String getFamily() {
        return this.family;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public void setStartDate(long startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(long endDate) {
        this.endDate = endDate;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public String getHumanStartDate() {
        return DateUtils.calculate_ISO8601((long)this.getStartDate());
    }

    public String getHumanEndDate() {
        return DateUtils.calculate_ISO8601((long)this.getEndDate());
    }

    public long getEndDate() {
        return this.endDate;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getErrorStacktrace() {
        return this.errorStacktrace;
    }

    public void setErrorStacktrace(String errorStacktrace) {
        this.errorStacktrace = errorStacktrace;
    }

    public void setOutputParams(Map<String, String> outputParams) {
        this.outputParams = outputParams;
    }

    public Map<String, String> getOutputParams() {
        return this.outputParams;
    }

    public String getParentProfileId() {
        return this.parentProfileId;
    }

    public static enum StartMode {
        AUTO,
        MANUAL,
        DISABLED;

    }

    public static enum Status {
        CREATED,
        EXECUTING,
        SUCCESS,
        FAILURE,
        KILLED;

    }
}

