package eu.dnetlib.msro.workflows.nodes.db;

import java.io.IOException;
import java.nio.charset.Charset;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DatabaseService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class QueryDbJobNode extends AsyncJobNode {

	private String db;

	private String sql;
	private String sqlForSize;
	private String xslt;
	private String outputEprParam;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {
		final String sqlText = fetchSqlAsText(this.sql);

		ResultSet<String> rs = null;

		final DatabaseService dbService = this.serviceLocator.getService(DatabaseService.class);

		if (StringUtils.isNotBlank(this.xslt)) {
			final String xsltText = IOUtils.toString(getClass().getResourceAsStream(this.xslt), Charset.forName("UTF-8"));

			if (StringUtils.isBlank(this.sqlForSize)) {
				rs = dbService.xsltSearchSQL(getDb(), sqlText, xsltText);
			} else {
				rs = dbService.alternativeXsltSearchSQL(getDb(), sqlText, fetchSqlAsText(this.sqlForSize), xsltText);
			}
		} else {
			if (StringUtils.isBlank(this.sqlForSize)) {
				rs = dbService.searchSQL(getDb(), sqlText);
			} else {
				rs = dbService.alternativeSearchSQL(getDb(), sqlText, fetchSqlAsText(this.sqlForSize));
			}
		}

		env.setAttribute(this.outputEprParam, rs);

		return Arc.DEFAULT_ARC;
	}

	private String fetchSqlAsText(final String path) throws IOException {
		return IOUtils.toString(getClass().getResourceAsStream(path), Charset.forName("UTF-8"));
	}

	public String getDb() {
		return this.db;
	}

	public void setDb(final String db) {
		this.db = db;
	}

	public String getSql() {
		return this.sql;
	}

	public void setSql(final String sql) {
		this.sql = sql;
	}

	public String getXslt() {
		return this.xslt;
	}

	public void setXslt(final String xslt) {
		this.xslt = xslt;
	}

	public String getOutputEprParam() {
		return this.outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public String getSqlForSize() {
		return this.sqlForSize;
	}

	public void setSqlForSize(final String sqlForSize) {
		this.sqlForSize = sqlForSize;
	}

}
