<?xml version="1.0" encoding="UTF-8"?>
<RESOURCE_PROFILE>
    <HEADER>
        <RESOURCE_IDENTIFIER value=""/>
        <RESOURCE_TYPE value="WorkflowDSResourceType"/>
        <RESOURCE_KIND value="WorkflowDSResources"/>
        <RESOURCE_URI value=""/>
        <DATE_OF_CREATION value=""/>
    </HEADER>
    <BODY>
        <WORKFLOW_NAME>$name$</WORKFLOW_NAME>
        <WORKFLOW_DESCRIPTION>$desc$</WORKFLOW_DESCRIPTION>
        <WORKFLOW_INFO />
        <WORKFLOW_FAMILY>aggregator</WORKFLOW_FAMILY>
        <WORKFLOW_PRIORITY>$priority$</WORKFLOW_PRIORITY>
        <DATASOURCE id="$dsId$" interface="$interface$" />

        <CONFIGURATION status="WAIT_SYS_SETTINGS" start="MANUAL">
            <PARAMETERS>
            	<PARAM name="collMdstoreId"        description="Store for collected records"    required="true" managedBy="system" category="MDSTORE_ID"/>
            	<PARAM name="collMdstoreFormat"    description="Format of collected records"    required="true" managedBy="system"/>
				<PARAM name="collectionMode"       description="Collection Mode (REFRESH / INCREMENTAL)" required="true" managedBy="user" type="string" function="validValues(['REFRESH','INCREMENTAL'])"/>
            	<PARAM name="tranMdstoreId"        description="Store for transformed records"  required="true" managedBy="system" category="MDSTORE_ID"/>
            	<PARAM name="tranMdstoreFormat"    description="Format of transformed records"  required="true" managedBy="system"/>
				<PARAM name="transformationRuleId" description="Transformation Rule Identifier" required="true" managedBy="user" type="string" function="listProfiles('TransformationRuleDSResourceType', '//TITLE')" category="TRANSFORMATION_RULE_ID"/>
            </PARAMETERS>
            <WORKFLOW>
                <NODE isStart="true" name="collection" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Collect records</DESCRIPTION>
                    <PARAMETERS>
                    	<PARAM name="name" value="Collection" />
                    	<PARAM name="wfTemplateId" value="51043d43-8546-4e2d-a20b-9f45829c0c5c_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                    	<PARAM name="wfTemplateParams">
                    		<MAP>
                    			<ENTRY key="dsId"          value="$dsId$" />
 								<ENTRY key="interface"     value="$interface$" />  	
	 							<ENTRY key="collMdstoreId" ref="collMdstoreId" />
 								<ENTRY key="selectMode"    ref="collectionMode" />  	
                    		</MAP>
                    	</PARAM>
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="transform"/>
                    </ARCS>
                </NODE>
                <NODE name="transform" type="LaunchWorkflowTemplate">
                    <DESCRIPTION>Transform record</DESCRIPTION>
                    <PARAMETERS>
						<PARAM name="name" value="Transform" />
                    	<PARAM name="wfTemplateId" value="0614918a-39c2-4ff2-8876-a1facc54ff9b_V29ya2Zsb3dUZW1wbGF0ZURTUmVzb3VyY2VzL1dvcmtmbG93VGVtcGxhdGVEU1Jlc291cmNlVHlwZQ==" />
                    	<PARAM name="wfTemplateParams">
                    		<MAP>
                    			<ENTRY key="dsId"          value="$dsId$" />
 								<ENTRY key="interface"     value="$interface$" />
 								<ENTRY key="collMdstoreId" ref="collMdstoreId" />
 								<ENTRY key="tranMdstoreId" ref="tranMdstoreId" />
 								<ENTRY key="ruleId"        ref="transformationRuleId" />
 							</MAP>
 						</PARAM>                 
                    </PARAMETERS>
                    <ARCS>
                        <ARC to="success"/>
                    </ARCS>
                </NODE>
            </WORKFLOW>
        </CONFIGURATION>
        
        <NOTIFICATIONS/>
        
        <SCHEDULING enabled="false">
            <CRON>9 9 9 ? * *</CRON>
            <MININTERVAL>10080</MININTERVAL>
        </SCHEDULING>
        <STATUS/>
    </BODY>
</RESOURCE_PROFILE>
