package eu.dnetlib.msro.workflows.util;

import java.util.List;
import java.util.stream.Collectors;

import eu.dnetlib.msro.workflows.procs.ProcessRegistry;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;

public class SubWorkflowProgressProvider implements ProgressProvider {

	private final String procId;
	private final ProcessRegistry processRegistry;

	public SubWorkflowProgressProvider(final String procId, final ProcessRegistry processRegistry) {
		super();
		this.procId = procId;
		this.processRegistry = processRegistry;
	}

	@Override
	public String getProgressDescription() {
		final WorkflowProcess proc = this.processRegistry.findProcess(this.procId);

		if (proc == null) { return "-"; }

		final List<String> list = proc.getTokens()
				.stream()
				.filter(t -> t.isActive())
				.map(t -> t.getProgressProvider() != null ? String.format("%s (%s)", t.getNodeName(), t.getProgressProvider().getProgressDescription())
						: t.getNodeName())
				.collect(Collectors.toList());
		if (!list.isEmpty()) { return list.stream().collect(Collectors.joining(", ")); }

		return "-";
	}

}
