/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.blackboard;

import eu.dnetlib.enabling.tools.blackboard.AbstractBlackboardJobListener;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlackboardWorkflowJobListener
extends AbstractBlackboardJobListener {
    private static final Log log = LogFactory.getLog(BlackboardWorkflowJobListener.class);
    private Token token;

    public BlackboardWorkflowJobListener(Token token) {
        this.token = token;
    }

    protected void onDone(BlackboardJob job) {
        log.debug((Object)"Blackboard workflow node DONE");
        this.responseToEnv(this.token.getEnv(), job.getParameters());
        this.token.setNextArc(Arc.DEFAULT_ARC);
        this.token.release();
    }

    public final void processJob(BlackboardJob job) {
        this.token.getEnv().setAttribute("blackboard:job", job);
        super.processJob(job);
    }

    protected final void onFailed(BlackboardJob job) {
        log.warn((Object)("Blackboard workflow node FAILED: " + job.getError()));
        this.responseToEnv(this.token.getEnv(), job.getParameters());
        this.token.releaseAsFailed(job.getError());
    }

    protected void responseToEnv(Env env, Map<String, String> responseParams) {
        for (Map.Entry<String, String> entry : responseParams.entrySet()) {
            env.setAttribute("blackboard:param:" + entry.getKey(), entry.getValue());
        }
    }

    protected void onOngoing(BlackboardJob job) {
        log.debug((Object)"Blackboard workflow node ONGOING");
        this.token.getEnv().setAttribute("blackboard:isOngoing", true);
    }

    public Token getToken() {
        return this.token;
    }

    public void setToken(Token token) {
        this.token = token;
    }
}

