/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.misc;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SleepJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(SleepJobNode.class);
    private long seconds = 3L;
    private String message;

    @Override
    protected String execute(Env env) throws Exception {
        log.info((Object)String.format("Start Sleeping for %s second...", this.seconds));
        Thread.sleep(TimeUnit.SECONDS.toMillis(this.seconds));
        log.info((Object)"...finished");
        if (StringUtils.isNotBlank((CharSequence)this.message)) {
            log.info((Object)"*****************************************************************");
            log.info((Object)("* " + this.message));
            log.info((Object)"*****************************************************************");
        }
        return Arc.DEFAULT_ARC;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public void setSeconds(long seconds) {
        this.seconds = seconds;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

