/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.objectStore;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.download.UrlExtractor;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class RetrieveURLSJobNode
extends SimpleJobNode {
    private String inputEprParam;
    private String outputEprParam;
    private String xpath;
    private String xpathMetadataId;
    private String xpathOpenAccess;
    private String xpathEmbargoDate;
    @Autowired
    private ResultSetFactory resultSetFactory;
    @Autowired
    private ResultSetClient resultSetClient;

    @Override
    protected String execute(Env env) throws Exception {
        ResultSet rsIn = env.getAttribute(this.inputEprParam, ResultSet.class);
        Iterable input = this.resultSetClient.iter(rsIn, String.class);
        UrlExtractor mapper = new UrlExtractor(this.xpath, this.xpathMetadataId, this.xpathOpenAccess, this.xpathEmbargoDate);
        ResultSet rsUrls = this.resultSetFactory.createResultSet(() -> StreamSupport.stream(input.spliterator(), false).map(mapper).iterator());
        env.setAttribute(this.getOutputEprParam(), rsUrls);
        return Arc.DEFAULT_ARC;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public String getXpathMetadataId() {
        return this.xpathMetadataId;
    }

    @Required
    public void setXpathMetadataId(String xpathMetadataId) {
        this.xpathMetadataId = xpathMetadataId;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getXpathOpenAccess() {
        return this.xpathOpenAccess;
    }

    public void setXpathOpenAccess(String xpathOpenAccess) {
        this.xpathOpenAccess = xpathOpenAccess;
    }

    public String getXpathEmbargoDate() {
        return this.xpathEmbargoDate;
    }

    public void setXpathEmbargoDate(String xpathEmbargoDate) {
        this.xpathEmbargoDate = xpathEmbargoDate;
    }
}

