/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.transform;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Resource;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class MdBuilderJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(MdBuilderJobNode.class);
    private org.springframework.core.io.Resource mdBuilderTemplateXslt;
    private String inputEprParam;
    private String outputEprParam;
    private String datasourceId;
    private String datasourceInterface;
    private String datasourceName;
    @Autowired
    private ResultSetFactory resultSetFactory;
    @Resource
    private UniqueServiceLocator serviceLocator;

    @Override
    protected String execute(Env env) throws MSROException {
        ResultSet rsIn = env.getAttribute(this.inputEprParam, ResultSet.class);
        if (rsIn == null) {
            throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV");
        }
        StringTemplate st = null;
        try {
            st = new StringTemplate(IOUtils.toString((InputStream)this.getMdBuilderTemplateXslt().getInputStream(), (Charset)Charset.forName("UTF-8")));
            st.setAttribute("datasourceId", (Object)this.datasourceId);
            st.setAttribute("datasourceName", (Object)this.datasourceName);
            st.setAttribute("datasourceApi", (Object)this.datasourceInterface);
            st.setAttribute("xpath", (Object)this.getMetadataIdentifierPath().replace("\"", "'"));
            st.setAttribute("baseurl", (Object)URLEncoder.encode(this.getBaseUrl(), "UTF-8"));
            st.setAttribute("metadatanamespace", (Object)this.getMetadataNamespace());
            String xQuery = "/*[.//RESOURCE_IDENTIFIER/@value='" + this.datasourceId + "']//EXTRA_FIELDS/FIELD/value[../key='NamespacePrefix']/string()";
            List namespacePrefix = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xQuery);
            if (namespacePrefix != null && namespacePrefix.size() != 0) {
                st.setAttribute("namespacePrefix", namespacePrefix.get(0));
            }
            ResultSet rsOut = this.resultSetFactory.xsltMap(rsIn, st.toString());
            env.setAttribute(this.outputEprParam, rsOut);
            if (this.datasourceInterface != null) {
                env.setAttribute("datasource:interface", this.datasourceInterface);
            }
            return Arc.DEFAULT_ARC;
        }
        catch (ISLookUpException e) {
            throw new MSROException("Error while initializing mdBuilder template (" + this.getMdBuilderTemplateXslt().getFilename() + ") for datasource " + this.datasourceId, (Throwable)e);
        }
        catch (IOException e) {
            throw new MSROException("Error parsing template: " + this.getMdBuilderTemplateXslt().getFilename(), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)st.toString());
            throw new MSROException((Throwable)e);
        }
    }

    private String getBaseUrl() throws ISLookUpException {
        String xQuery = "/*[.//RESOURCE_IDENTIFIER/@value='{datasourceId}']//INTERFACE[@id='{interfaceId}']//BASE_URL/string()";
        xQuery = xQuery.replace("{interfaceId}", this.datasourceInterface).replace("{datasourceId}", this.datasourceId);
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xQuery);
    }

    private String getMetadataIdentifierPath() throws ISLookUpException {
        String xQuery = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') return $x//INTERFACE[@id='{interfaceId}']/INTERFACE_EXTRA_FIELD[@name='metadata_identifier_path']/string()";
        xQuery = xQuery.replace("{interfaceId}", this.datasourceInterface);
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xQuery);
    }

    private String getMetadataNamespace() {
        try {
            String xQuery = "let $x := /*[.//RESOURCE_IDENTIFIER/@value='{datasourceId}']//INTERFACE[@id='{interfaceId}']/ACCESS_PROTOCOL/@format/string() return /*[.//RESOURCE_TYPE/@value='MetadataFormatDSResourceType']//METADATAFORMAT[@Prefix=$x]/@NameSpace/string()";
            xQuery = xQuery.replace("{interfaceId}", this.datasourceInterface).replace("{datasourceId}", this.datasourceId);
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xQuery);
        }
        catch (ISLookUpException e) {
            log.error((Object)"The interface is not OAI or the format is not found in the MetadataFormatDSResourceType, thus metadata format in the <about> section cannot be managed here and it will be left incomplete (for the time being)");
            return "";
        }
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getDatasourceName() {
        return this.datasourceName;
    }

    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    public org.springframework.core.io.Resource getMdBuilderTemplateXslt() {
        return this.mdBuilderTemplateXslt;
    }

    @Required
    public void setMdBuilderTemplateXslt(org.springframework.core.io.Resource mdBuilderTemplateXslt) {
        this.mdBuilderTemplateXslt = mdBuilderTemplateXslt;
    }
}

