/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.kv.subdoc.multi;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.core.message.kv.subdoc.multi.MutationCommand;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class MutationCommandBuilder {
    private Mutation mutation;
    private String path;
    private ByteBuf fragment;
    private boolean createIntermediaryPath;
    private boolean xattr;

    public MutationCommandBuilder(Mutation mutation, String path) {
        this.mutation = mutation;
        this.path = path;
        this.fragment = Unpooled.EMPTY_BUFFER;
    }

    public MutationCommandBuilder(Mutation mutation, String path, ByteBuf fragment) {
        this.mutation = mutation;
        this.path = path;
        this.fragment = fragment == null ? Unpooled.EMPTY_BUFFER : fragment;
    }

    public MutationCommand build() {
        return new MutationCommand(this);
    }

    public Mutation mutation() {
        return this.mutation;
    }

    public String path() {
        return this.path;
    }

    ByteBuf fragment() {
        return this.fragment;
    }

    public byte opCode() {
        return this.mutation.opCode();
    }

    public boolean createIntermediaryPath() {
        return this.createIntermediaryPath;
    }

    public boolean xattr() {
        return this.xattr;
    }

    public MutationCommandBuilder createIntermediaryPath(boolean createIntermediaryPath) {
        this.createIntermediaryPath = createIntermediaryPath;
        return this;
    }

    public MutationCommandBuilder fragment(ByteBuf fragment) {
        this.fragment = fragment;
        return this;
    }

    public MutationCommandBuilder xattr(boolean xattr) {
        this.xattr = xattr;
        return this;
    }
}

